/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.filemanager.ver3.search;

import ddb.dsz.plugin.filemanager.ver3.search.DateSearchType;
import ddb.dsz.plugin.filemanager.ver3.search.MimeTypeMap;
import ddb.dsz.plugin.filemanager.ver3.search.Search;
import ddb.targetmodel.filemodel.FileObject;
import ddb.targetmodel.filemodel.FileObjectFields;
import ddb.targetmodel.filemodel.FileSystemModel;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.commons.collections.Closure;

public class Searcher
implements Runnable {
    public static final int MAX_PARENTS = 100;
    private boolean stop = false;
    private boolean running = false;
    Closure onFinished;
    FileSystemModel model;
    Closure addNode;
    public String name = null;
    public FileObject searchRoot = null;
    public DateSearchType dateType = null;
    public int lastDays = -1;
    public Calendar spanStart;
    public Calendar spanStop;
    public MimeTypeMap.MimeType mimeType;
    public boolean isCaseSensitive = false;
    public long minimumSize = -1L;
    public long maximumSize = -1L;
    public SearchType searchType = SearchType.GLOB;
    public Pattern regexPattern = null;
    private Search search;

    public boolean isRunning() {
        return this.running;
    }

    public Searcher(FileSystemModel fileSystemModel, Search search, Closure closure, Closure closure2) {
        this.onFinished = closure;
        this.model = fileSystemModel;
        this.addNode = closure2;
        this.search = search;
    }

    public void stop() {
        this.stop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void run() {
        this.running = true;
        int n = 0;
        try {
            Object object;
            String[] stringArray = new String[]{"select * From ", "File LEFT OUTER JOIN Directory ON File.FileId = Directory.DirId ", "LEFT OUTER JOIN Drive ON Directory.DirId = Drive.DriveId ", "Where File.Parent IN (", "", ") AND (", "", ")"};
            String[] stringArray2 = new String[]{"select FileId, DirId From ", "Directory INNER JOIN FILE ON File.FileId = Directory.DirId ", "Where File.Parent IN (", "", ") AND Directory.DirId NOTNULL"};
            ArrayList<SetParameter> arrayList = new ArrayList<SetParameter>();
            Vector<Long> vector = new Vector<Long>();
            if (this.searchRoot == null) {
                vector.add(FileSystemModel.ROOT);
            } else {
                vector.add(this.searchRoot.getId());
            }
            this.searchRoot = null;
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = 1;
            if (this.name != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" AND ");
                }
                switch (this.searchType) {
                    case GLOB: {
                        if (this.isCaseSensitive) {
                            stringBuilder.append(String.format("File.%s Glob ?", FileObjectFields.File_Name.getName()));
                            arrayList.add(new SetString(n2, this.name));
                        } else {
                            stringBuilder.append(String.format("lower(File.%s) Glob ?", FileObjectFields.File_Name.getName()));
                            arrayList.add(new SetString(n2, this.name.toLowerCase()));
                        }
                        ++n2;
                        break;
                    }
                    case REGEX: {
                        stringBuilder.append("1=1");
                        break;
                    }
                }
            }
            if (this.minimumSize != -1L) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" AND ");
                }
                stringBuilder.append(String.format("File.%s >= ?", FileObjectFields.File_Size.getName()));
                arrayList.add(new SetLong(n2, this.minimumSize));
                ++n2;
            }
            if (this.maximumSize != -1L) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" AND ");
                }
                stringBuilder.append(String.format("File.%s <= ?", FileObjectFields.File_Size.getName()));
                arrayList.add(new SetLong(n2, this.maximumSize));
                ++n2;
            }
            if (this.lastDays != -1) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" AND ");
                }
                switch (this.dateType) {
                    case Accessed: {
                        stringBuilder.append(String.format("File.%s >= ?", FileObjectFields.File_Accessed.getName()));
                        break;
                    }
                    case Created: {
                        stringBuilder.append(String.format("File.%s >= ?", FileObjectFields.File_Created.getName()));
                        break;
                    }
                    default: {
                        stringBuilder.append(String.format("File.%s >= ?", FileObjectFields.File_Modified.getName()));
                    }
                }
                object = Calendar.getInstance();
                ((Calendar)object).add(5, -this.lastDays);
                arrayList.add(new SetCalendar(n2++, (Calendar)object));
            }
            if (this.spanStart != null && this.spanStop != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" AND ");
                }
                switch (this.dateType) {
                    case Accessed: {
                        stringBuilder.append(String.format("File.%s ", FileObjectFields.File_Accessed.getName()));
                        break;
                    }
                    case Created: {
                        stringBuilder.append(String.format("File.%s ", FileObjectFields.File_Created.getName()));
                        break;
                    }
                    default: {
                        stringBuilder.append(String.format("File.%s ", FileObjectFields.File_Modified.getName()));
                    }
                }
                stringBuilder.append("BETWEEN ? AND ?");
                arrayList.add(new SetCalendar(n2++, this.spanStart));
                arrayList.add(new SetCalendar(n2++, this.spanStop));
            }
            if (stringBuilder.length() == 0) {
                stringBuilder.append("1=1");
            }
            stringArray[6] = stringBuilder.toString();
            block14: while (!vector.isEmpty() && !this.stop) {
                String string;
                void var13_20;
                object = vector.subList(0, Math.min(vector.size(), 100));
                n += object.size();
                StringBuilder stringBuilder2 = new StringBuilder();
                Object object3 = object.iterator();
                while (object3.hasNext()) {
                    Long l = (Long)object3.next();
                    if (stringBuilder2.length() > 0) {
                        stringBuilder2.append(", ");
                    }
                    stringBuilder2.append(l);
                }
                stringArray[4] = stringBuilder2.toString();
                stringArray2[3] = stringBuilder2.toString();
                object3 = new StringBuilder();
                String[] stringArray3 = stringArray;
                int n3 = stringArray3.length;
                boolean bl = false;
                while (var13_20 < n3) {
                    string = stringArray3[var13_20];
                    ((StringBuilder)object3).append(string);
                    ++var13_20;
                }
                PreparedStatement preparedStatement = this.model.prepareStatement(((StringBuilder)object3).toString());
                for (Closure closure : arrayList) {
                    closure.execute((Object)preparedStatement);
                }
                Object object2 = this.model.getArbitraryQuery(preparedStatement);
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    string = (FileObject)iterator.next();
                    if (this.stop) break;
                    if (this.regexPattern != null) {
                        String string2 = string.getName();
                        if (!this.isCaseSensitive) {
                            string2 = string2.toLowerCase();
                        }
                        if (!this.regexPattern.matcher(string2).matches()) continue;
                    }
                    if (this.mimeType != null) {
                        boolean bl2 = false;
                        for (String string3 : this.mimeType.getSuffixes()) {
                            if (!string.getName().toLowerCase().endsWith(string3)) continue;
                            bl2 = true;
                            break;
                        }
                        if (!bl2) continue;
                    }
                    this.addNode.execute((Object)string);
                }
                this.search.setStatus(String.format("%d directories searched", n));
                object3 = new StringBuilder();
                for (String string4 : stringArray2) {
                    ((StringBuilder)object3).append(string4);
                }
                PreparedStatement object22 = this.model.prepareStatement(((StringBuilder)object3).toString());
                object.clear();
                object2 = this.model.getArbitraryQuery(object22);
                Iterator iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    FileObject fileObject = (FileObject)iterator2.next();
                    if (this.stop) continue block14;
                    if (!fileObject.isDirectory()) continue;
                    vector.add(fileObject.getId());
                }
            }
        }
        catch (Throwable throwable) {
            this.search.setStatus(String.format("Search complete.  %d directories search", n));
            if (this.onFinished != null) {
                this.onFinished.execute(null);
            }
            this.running = false;
            throw throwable;
        }
        this.search.setStatus(String.format("Search complete.  %d directories search", n));
        if (this.onFinished != null) {
            this.onFinished.execute(null);
        }
        this.running = false;
    }

    private class SetCalendar
    extends SetParameter {
        Calendar cal;

        public SetCalendar(int n, Calendar calendar) {
            super(n);
            this.cal = calendar;
        }

        protected void execute(PreparedStatement preparedStatement) throws SQLException {
            preparedStatement.setTimestamp(this.index, new Timestamp(this.cal.getTimeInMillis()), this.cal);
        }
    }

    private class SetLong
    extends SetParameter {
        long l;

        public SetLong(int n, long l) {
            super(n);
            this.l = l;
        }

        protected void execute(PreparedStatement preparedStatement) throws SQLException {
            preparedStatement.setLong(this.index, this.l);
        }
    }

    private class SetString
    extends SetParameter {
        String s;

        public SetString(int n, String string) {
            super(n);
            this.s = string;
        }

        protected void execute(PreparedStatement preparedStatement) throws SQLException {
            preparedStatement.setString(this.index, this.s);
        }
    }

    private abstract class SetParameter
    implements Closure {
        int index;

        protected SetParameter(int n) {
            this.index = n;
        }

        public final void execute(Object object) {
            try {
                this.execute((PreparedStatement)PreparedStatement.class.cast(object));
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }

        protected abstract void execute(PreparedStatement var1) throws SQLException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchType {
        GLOB("Glob"),
        REGEX("Regular Expression");

        String type;

        private SearchType(String string2) {
            this.type = string2;
        }

        public String toString() {
            return this.type;
        }
    }
}

