/*
 * Decompiled with CFR 0.152.
 */
package ddb.util.predicate;

import java.util.List;
import java.util.Vector;
import org.apache.commons.collections.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionListPredicate<E>
implements Predicate {
    List<E> objects = new Vector();
    boolean allowAllOnEmpty;

    public UnionListPredicate(boolean bl) {
        this.allowAllOnEmpty = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evaluate(Object object) {
        UnionListPredicate unionListPredicate = this;
        synchronized (unionListPredicate) {
            if (this.objects.size() == 0) {
                return this.allowAllOnEmpty;
            }
            for (E e : this.objects) {
                if (!e.equals(object)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(E e) {
        UnionListPredicate unionListPredicate = this;
        synchronized (unionListPredicate) {
            if (this.objects.contains(e)) {
                return;
            }
            this.objects.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeItem(E e) {
        UnionListPredicate unionListPredicate = this;
        synchronized (unionListPredicate) {
            this.objects.remove(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        UnionListPredicate unionListPredicate = this;
        synchronized (unionListPredicate) {
            this.objects.clear();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UnionList[");
        if (this.allowAllOnEmpty && this.objects.isEmpty()) {
            stringBuilder.append("-all-");
        } else {
            boolean bl = true;
            for (E e : this.objects) {
                if (!bl) {
                    stringBuilder.append(", ");
                    bl = false;
                }
                stringBuilder.append(e.toString());
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

