/*
 * Decompiled with CFR 0.152.
 */
package ddb.util.tablefilter;

import ddb.util.UtilityConstants;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReadWriteLock;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.collections.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredTableModel
extends AbstractTableModel
implements TableModel,
TableModelListener {
    ExecutorService exec = UtilityConstants.createSingleThreadExecutorService("RowFilter");
    List<Integer> rowTranslation = new ArrayList<Integer>();
    TableModel child = null;
    List<FilterRecord> filters = new ArrayList<FilterRecord>();
    private ReadWriteLock access = UtilityConstants.createReadWriteLock();
    private boolean bUpdating = false;
    private boolean bRunAgain = false;
    protected final Runnable Update = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            try {
                int n;
                int n2;
                object = null;
                int n3 = 0;
                FilteredTableModel.this.readLock();
                try {
                    object = new Integer[FilteredTableModel.this.child.getRowCount()];
                    int n4 = ((Integer[])object).length / 10;
                    for (n2 = 0; n2 < FilteredTableModel.this.child.getRowCount(); ++n2) {
                        if (FilteredTableModel.this.show(n2)) {
                            object[n3++] = n2;
                        }
                        try {
                            if (n2 % n4 == 0) {
                                Thread.sleep(1L);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Thread.yield();
                    }
                }
                finally {
                    FilteredTableModel.this.readUnlock();
                }
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                n2 = 0;
                int n5 = 0;
                FilteredTableModel.this.writeLock();
                try {
                    List<Integer> list = Arrays.asList(object).subList(0, n3);
                    n = 0;
                    if (list.size() > FilteredTableModel.this.rowTranslation.size()) {
                        n = FilteredTableModel.this.rowTranslation.size();
                        n2 = list.size() - FilteredTableModel.this.rowTranslation.size();
                    } else if (list.size() < FilteredTableModel.this.rowTranslation.size()) {
                        n = list.size();
                        n5 = FilteredTableModel.this.rowTranslation.size() - list.size();
                    } else {
                        n = list.size();
                    }
                    for (int i = 0; i < n; ++i) {
                        if (FilteredTableModel.this.rowTranslation.get(i) == list.get(i)) continue;
                        arrayList.add(i);
                    }
                    FilteredTableModel.this.rowTranslation = list;
                }
                finally {
                    FilteredTableModel.this.writeUnlock();
                }
                int n6 = Integer.MIN_VALUE;
                n = Integer.MIN_VALUE;
                for (Integer n7 : arrayList) {
                    if (n + 1 == n7) {
                        n = n7;
                        continue;
                    }
                    if (n6 < 0) {
                        n6 = n = n7.intValue();
                        continue;
                    }
                    EventQueue.invokeLater(new FireTableRowsUpdated(n6, n));
                    n = Integer.MIN_VALUE;
                    n6 = Integer.MIN_VALUE;
                }
                if (n6 >= 0) {
                    EventQueue.invokeLater(new FireTableRowsUpdated(n6, n));
                }
                if (n2 > 0) {
                    EventQueue.invokeLater(new FireTableRowsInserted(FilteredTableModel.this.rowTranslation.size() - n2, FilteredTableModel.this.rowTranslation.size() - 1));
                }
                if (n5 > 0) {
                    EventQueue.invokeLater(new FireTableRowsInserted(FilteredTableModel.this.rowTranslation.size(), FilteredTableModel.this.rowTranslation.size() + n5));
                }
            }
            finally {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
                object = this;
                synchronized (object) {
                    if (FilteredTableModel.this.bRunAgain) {
                        FilteredTableModel.this.bRunAgain = false;
                        FilteredTableModel.this.exec.submit(this);
                    } else {
                        FilteredTableModel.this.bUpdating = false;
                    }
                }
            }
        }
    };

    protected void readLock() {
        this.access.readLock().lock();
    }

    protected void writeLock() {
        this.access.writeLock().lock();
    }

    protected void readUnlock() {
        this.access.readLock().unlock();
    }

    protected void writeUnlock() {
        this.access.writeLock().unlock();
    }

    public FilteredTableModel(TableModel tableModel) {
        this.child = tableModel;
        if (tableModel != null) {
            tableModel.addTableModelListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        this.readLock();
        try {
            int n = this.rowTranslation.size();
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModel(TableModel tableModel) {
        this.writeLock();
        try {
            if (this.child != null) {
                this.child.removeTableModelListener(this);
            }
            this.child = tableModel;
            if (this.child != null) {
                this.child.addTableModelListener(this);
            }
        }
        finally {
            this.writeUnlock();
        }
        this.submitUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        block15: {
            if (tableModelEvent.getFirstRow() == -1 && tableModelEvent.getLastRow() == -1 && tableModelEvent.getColumn() == -1) {
                EventQueue.invokeLater(new FireTableStructureChanged());
            } else {
                try {
                    if (tableModelEvent.getLastRow() > this.child.getRowCount() || tableModelEvent.getFirstRow() == -1) {
                        this.submitUpdate();
                        return;
                    }
                    switch (tableModelEvent.getType()) {
                        case 0: {
                            for (int i = tableModelEvent.getLastRow(); i <= tableModelEvent.getFirstRow(); ++i) {
                                this.readLock();
                                try {
                                    int n = this.translateModelRowToViewRow(i);
                                    if (n != -1) {
                                        EventQueue.invokeLater(new FireTableRowsUpdated(n, n));
                                        continue;
                                    }
                                    if (!this.show(i)) continue;
                                    this.submitUpdate();
                                    break block15;
                                }
                                finally {
                                    this.readUnlock();
                                }
                            }
                            break;
                        }
                        case -1: {
                            this.submitUpdate();
                            break;
                        }
                        case 1: {
                            this.submitUpdate();
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int translateModelRowToViewRow(int n) {
        this.readLock();
        try {
            int n2;
            for (n2 = 0; n2 < this.rowTranslation.size(); ++n2) {
                if (this.rowTranslation.get(n2) != n) continue;
                int n3 = n2;
                return n3;
            }
            n2 = -1;
            return n2;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int lastRowBefore(int n) {
        this.readLock();
        try {
            int n2;
            for (n2 = 0; n2 < this.rowTranslation.size(); ++n2) {
                if (this.rowTranslation.get(n2) < n) continue;
                int n3 = n2;
                return n3;
            }
            n2 = this.rowTranslation.size();
            return n2;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int translateViewLocationToModelRow(int n, int n2) {
        if (n <= -1) {
            return -1;
        }
        this.readLock();
        try {
            if (this.rowTranslation.size() <= n) {
                int n3 = -1;
                return n3;
            }
            int n4 = this.rowTranslation.get(n);
            return n4;
        }
        finally {
            this.readUnlock();
        }
    }

    public void filterChanged() {
        this.submitUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitUpdate() {
        Runnable runnable = this.Update;
        synchronized (runnable) {
            if (this.bUpdating) {
                this.bRunAgain = true;
                return;
            }
            this.bUpdating = true;
            this.exec.submit(this.Update);
        }
    }

    protected boolean show(int n) {
        try {
            for (FilterRecord filterRecord : this.filters) {
                if (this.show(n, filterRecord)) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
        }
        return true;
    }

    private boolean show(int n, FilterRecord filterRecord) {
        int n2 = 0;
        for (int n3 : filterRecord.columns) {
            if (!filterRecord.filter.evaluate(this.child.getValueAt(n, n3))) continue;
            ++n2;
        }
        switch (filterRecord.match) {
            case All: {
                return n2 == filterRecord.columns.length;
            }
            case Single: {
                return n2 > 0;
            }
        }
        return false;
    }

    public void addFilter(Predicate predicate, int ... nArray) {
        this.addFilter(predicate, MultipleColumnMatch.Single, nArray);
    }

    public void addFilter(Predicate predicate, Enum<?> ... enumArray) {
        this.addFilter(predicate, MultipleColumnMatch.Single, enumArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilter(Predicate predicate, MultipleColumnMatch multipleColumnMatch, int ... nArray) {
        if (predicate == null || nArray.length == 0) {
            return;
        }
        FilterRecord filterRecord = new FilterRecord();
        filterRecord.columns = nArray;
        filterRecord.filter = predicate;
        filterRecord.match = multipleColumnMatch;
        this.writeLock();
        try {
            this.filters.add(filterRecord);
        }
        finally {
            this.writeUnlock();
        }
        this.submitUpdate();
    }

    public void addFilter(Predicate predicate, MultipleColumnMatch multipleColumnMatch, Enum<?> ... enumArray) {
        int[] nArray = new int[enumArray.length];
        for (int i = 0; i < enumArray.length; ++i) {
            nArray[i] = enumArray[i].ordinal();
        }
        this.addFilter(predicate, multipleColumnMatch, nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getColumnCount() {
        this.readLock();
        try {
            int n = this.child.getColumnCount();
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int n, int n2) {
        this.readLock();
        try {
            Object object = this.child.getValueAt(this.translateViewLocationToModelRow(n, n2), n2);
            return object;
        }
        finally {
            this.readUnlock();
        }
    }

    public String toString() {
        return String.format("Filter (%s)", this.child.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.readLock();
        try {
            this.child.setValueAt(object, this.translateViewLocationToModelRow(n, n2), n2);
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCellEditable(int n, int n2) {
        this.readLock();
        try {
            boolean bl = this.child.isCellEditable(this.translateViewLocationToModelRow(n, n2), n2);
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public String getColumnName(int n) {
        return this.child.getColumnName(n);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.child.getColumnClass(n);
    }

    protected class FireTableCellUpdated
    implements Runnable {
        int i;
        int j;

        public FireTableCellUpdated(int n, int n2) {
            this.i = n;
            this.j = n2;
        }

        public void run() {
            FilteredTableModel.this.fireTableCellUpdated(this.i, this.j);
        }
    }

    protected class FireTableStructureChanged
    implements Runnable {
        public void run() {
            FilteredTableModel.this.fireTableStructureChanged();
        }
    }

    protected class FireTableDataChanged
    implements Runnable {
        public void run() {
            FilteredTableModel.this.fireTableDataChanged();
        }
    }

    protected class FireTableRowsDeleted
    implements Runnable {
        int i;
        int j;

        public FireTableRowsDeleted(int n, int n2) {
            this.i = n;
            this.j = n2;
        }

        public void run() {
            FilteredTableModel.this.fireTableRowsDeleted(this.i, this.j);
        }
    }

    protected class FireTableRowsInserted
    implements Runnable {
        int i;
        int j;

        public FireTableRowsInserted(int n, int n2) {
            this.i = n;
            this.j = n2;
        }

        public void run() {
            FilteredTableModel.this.fireTableRowsInserted(this.i, this.j);
        }
    }

    protected class FireTableRowsUpdated
    implements Runnable {
        int i;
        int j;

        public FireTableRowsUpdated(int n, int n2) {
            this.i = n;
            this.j = n2;
        }

        public void run() {
            FilteredTableModel.this.fireTableRowsUpdated(this.i, this.j);
        }
    }

    private class FilterRecord {
        int[] columns;
        Predicate filter;
        MultipleColumnMatch match = MultipleColumnMatch.All;

        private FilterRecord() {
        }

        public String toString() {
            String string = "";
            if (this.columns.length > 1) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int n : this.columns) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(n);
                }
                string = stringBuilder.toString();
            } else {
                string = String.format("%d", this.columns[0]);
            }
            return String.format("Filter (%s[%s])", this.filter.toString(), string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MultipleColumnMatch {
        Single,
        All;

    }
}

