/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.transfermonitor.model;

import ddb.dsz.core.task.Task;
import ddb.dsz.plugin.transfermonitor.TransferMonitorColumns;
import ddb.dsz.plugin.transfermonitor.model.TransferRecord;
import ddb.dsz.plugin.transfermonitor.model.TransferState;
import ddb.util.AbstractEnumeratedTableModel;
import java.awt.EventQueue;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferMonitorModel
extends AbstractEnumeratedTableModel<TransferMonitorColumns>
implements TableModel {
    List<TransferRecord> recordList;
    final ReadWriteLock LOCK = new ReentrantReadWriteLock();
    final Lock WRITE = this.LOCK.writeLock();
    final Lock READ = this.LOCK.readLock();

    public TransferMonitorModel() {
        super(TransferMonitorColumns.class);
        this.recordList = new Vector<TransferRecord>();
    }

    public String getColumnName(TransferMonitorColumns transferMonitorColumns) {
        return transferMonitorColumns.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        this.READ.lock();
        try {
            int n = this.recordList.size();
            return n;
        }
        finally {
            this.READ.unlock();
        }
    }

    public Class<?> getColumnClass(TransferMonitorColumns transferMonitorColumns) {
        return transferMonitorColumns.getClazz();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int n, TransferMonitorColumns transferMonitorColumns) {
        TransferRecord transferRecord = null;
        this.READ.lock();
        try {
            if (n >= 0 && n < this.recordList.size()) {
                transferRecord = this.recordList.get(n);
            }
        }
        finally {
            this.READ.unlock();
        }
        if (transferRecord == null) {
            return null;
        }
        switch (transferMonitorColumns) {
            case ID: {
                return new Integer(transferRecord.getId());
            }
            case STATE: {
                return transferRecord.getState();
            }
            case REMOTE: {
                return transferRecord.getRemote();
            }
            case LOCAL: {
                return transferRecord.getLocal();
            }
            case SIZE: {
                return transferRecord;
            }
            case TYPE: {
                return transferRecord.getDescription();
            }
            case TIME_ACCESSED: {
                return transferRecord.getAccessed();
            }
            case TIME_CREATED: {
                return transferRecord.getCreated();
            }
            case TIME_MODIFIED: {
                return transferRecord.getModified();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecord(TransferRecord transferRecord) {
        int n = -1;
        this.WRITE.lock();
        try {
            this.recordList.add(transferRecord);
            n = this.recordList.size() - 1;
        }
        finally {
            this.WRITE.unlock();
        }
        EventQueue.invokeLater((Runnable)new AbstractEnumeratedTableModel.FireTableRowsInserted((AbstractEnumeratedTableModel)this, n, n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferRecord getRecord(int n) {
        this.READ.lock();
        try {
            if (n < 0 || n >= this.recordList.size()) {
                TransferRecord transferRecord = null;
                return transferRecord;
            }
            TransferRecord transferRecord = this.recordList.get(n);
            return transferRecord;
        }
        finally {
            this.READ.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordChanged(TransferRecord transferRecord) {
        int n = -1;
        this.READ.lock();
        try {
            n = this.recordList.indexOf(transferRecord);
        }
        finally {
            this.READ.unlock();
        }
        if (n != -1) {
            EventQueue.invokeLater((Runnable)new AbstractEnumeratedTableModel.FireTableRowsUpdated((AbstractEnumeratedTableModel)this, n, n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNext() {
        this.READ.lock();
        try {
            int n = this.recordList.size();
            return n;
        }
        finally {
            this.READ.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commandEnded(Task task) {
        this.READ.lock();
        try {
            for (TransferRecord transferRecord : this.recordList) {
                if (!transferRecord.getTaskId().equals((Object)task.getId())) continue;
                transferRecord.setState(TransferState.DONE);
            }
        }
        finally {
            this.READ.unlock();
        }
    }
}

