/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.transfermonitor.tabs;

import ddb.detach.AbstractTabbable;
import ddb.detach.Alignment;
import ddb.detach.Workbench;
import ddb.dsz.plugin.transfermonitor.TransferTabbable;
import ddb.dsz.plugin.transfermonitor.displays.HexDisplay;
import ddb.dsz.plugin.transfermonitor.displays.TextDisplay;
import ddb.dsz.plugin.transfermonitor.model.TransferRecord;
import ddb.dsz.plugin.transfermonitor.tabs.TransferWorkbench;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferDetails
extends AbstractTabbable {
    TransferRecord record;
    JPanel blank = new JPanel();
    Workbench bench = new TransferWorkbench();

    public TransferDetails(TransferRecord transferRecord, File file) throws IOException {
        super.setAlignment(Alignment.RIGHT);
        super.setVerifyClose(false);
        super.setDetachable(true);
        super.setShowButtons(true);
        this.record = transferRecord;
        TransferTabbable transferTabbable = this.binaryDisplay(file);
        TransferTabbable transferTabbable2 = this.textDisplay(file);
        this.bench.enqueAction((Enum)Workbench.WorkbenchAction.ADDNEWTAB, new Object[]{transferTabbable});
        this.bench.enqueAction((Enum)Workbench.WorkbenchAction.ADDNEWTAB, new Object[]{transferTabbable2});
        super.registerDisplay((JComponent)this.bench);
    }

    protected JComponent getTabbableSpecificRenderComponent() {
        return null;
    }

    public boolean isClosable() {
        return true;
    }

    public JComponent getHeader() {
        return this.blank;
    }

    public String getName() {
        return this.record.getRemote();
    }

    public String getDetachedTitle() {
        return this.getName();
    }

    public String getDockedTitle() {
        return this.getName();
    }

    public boolean allowNewInstance(Class<?> clazz) {
        return false;
    }

    public JComponent initialFocus() {
        return null;
    }

    private TransferTabbable binaryDisplay(final File file) throws IOException {
        final HexDisplay hexDisplay = new HexDisplay();
        SwingWorker<byte[], byte[]> swingWorker = new SwingWorker<byte[], byte[]>(){

            @Override
            protected byte[] doInBackground() throws Exception {
                if (file.length() > 0L) {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    int n = fileInputStream.available();
                    byte[] byArray = new byte[n];
                    int n2 = 0;
                    int n3 = 0;
                    while (-1 != n3 && n2 != n) {
                        n3 = fileInputStream.read(byArray, n2 += n3, n - n2);
                    }
                    return byArray;
                }
                return "Unable to open file".getBytes();
            }

            @Override
            protected void done() {
                try {
                    hexDisplay.setData((byte[])this.get());
                }
                catch (Exception exception) {
                    hexDisplay.setData(String.format("Unable to get file: " + exception.getMessage(), new Object[0]).getBytes());
                }
            }
        };
        swingWorker.execute();
        return hexDisplay;
    }

    private TransferTabbable textDisplay(File file) throws IOException {
        return new TextDisplay(file);
    }

    public JLabel getTabComponent() {
        return new JLabel(this.record.getRemote());
    }
}

