/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.transfermonitor.tabs;

import ddb.detach.Alignment;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.internalcommand.InternalCommandCallback;
import ddb.dsz.core.task.Task;
import ddb.dsz.plugin.transfermonitor.TransferMonitorColumns;
import ddb.dsz.plugin.transfermonitor.TransferMonitorHost;
import ddb.dsz.plugin.transfermonitor.TransferTabbable;
import ddb.dsz.plugin.transfermonitor.model.TransferDirection;
import ddb.dsz.plugin.transfermonitor.model.TransferMonitorModel;
import ddb.dsz.plugin.transfermonitor.model.TransferMonitorTableSorter;
import ddb.dsz.plugin.transfermonitor.model.TransferRecord;
import ddb.dsz.plugin.transfermonitor.model.TransferState;
import ddb.dsz.plugin.transfermonitor.renderer.ProgressCellRenderer;
import ddb.dsz.plugin.transfermonitor.renderer.StateRenderer;
import ddb.gui.swing.DszTableCellRenderer;
import ddb.imagemanager.ImageManager;
import ddb.listeners.mouse.MousePopup;
import ddb.util.TableSorter;
import ddb.util.tablefilter.sample.ColumnHidingModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferMainTab
extends TransferTabbable {
    TransferMonitorModel getMonitorModel;
    int runningFileTypes = 0;
    JTable getTable;
    TableSorter sorter;
    JPopupMenu contextMenu = new JPopupMenu();
    TransferMonitorHost monitor;
    CoreController core;
    private static final String[] LIMITATIONS = new String[]{"-range", "-tail"};

    public TransferMainTab(TransferMonitorHost transferMonitorHost, CoreController coreController) {
        super("Transfers");
        this.core = coreController;
        super.setShowButtons(true);
        this.monitor = transferMonitorHost;
        this.getMonitorModel = new TransferMonitorModel();
        this.sorter = new TransferMonitorTableSorter(this.getMonitorModel);
        this.getTable = new JTable();
        ColumnHidingModel columnHidingModel = new ColumnHidingModel(TransferMonitorColumns.class);
        this.getTable.setColumnModel((TableColumnModel)columnHidingModel);
        this.getTable.setModel((TableModel)this.sorter);
        this.sorter.addMouseListenerToHeaderInTable(this.getTable);
        columnHidingModel.applyToTable(this.getTable);
        this.sorter.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                TransferMainTab.this.sorter.sort((Object)TransferMainTab.this);
            }
        });
        this.getTable.setDefaultRenderer(Calendar.class, (TableCellRenderer)new DszTableCellRenderer(){
            SimpleDateFormat FullFormat = new SimpleDateFormat("M/d/yyyy h:mm:ss a");
            SimpleDateFormat ShortFormat = new SimpleDateFormat("h:mm:ss a");

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (component instanceof JLabel && object instanceof Calendar) {
                    Calendar calendar = (Calendar)object;
                    JLabel jLabel = (JLabel)component;
                    Calendar calendar2 = Calendar.getInstance();
                    calendar2.add(5, -1);
                    if (calendar.compareTo(calendar2) < 0) {
                        jLabel.setText(this.FullFormat.format(calendar.getTime()));
                    } else {
                        jLabel.setText(this.ShortFormat.format(calendar.getTime()));
                    }
                }
                return component;
            }
        });
        this.getTable.setDefaultRenderer(TransferRecord.class, new ProgressCellRenderer());
        this.getTable.setDefaultRenderer(TransferState.class, (TableCellRenderer)((Object)new StateRenderer(this.core)));
        this.display.add(new JScrollPane(this.getTable));
        this.setColumnWidths();
        final JMenuItem jMenuItem = new JMenuItem("Save");
        final JMenuItem jMenuItem2 = new JMenuItem("Save All");
        final JMenuItem jMenuItem3 = new JMenuItem("Open");
        final JMenuItem jMenuItem4 = new JMenuItem("Copy Path");
        final JMenuItem jMenuItem5 = new JMenuItem("Resume");
        this.contextMenu.add(jMenuItem3);
        this.contextMenu.add(jMenuItem);
        this.contextMenu.add(jMenuItem2);
        this.contextMenu.add(jMenuItem4);
        this.contextMenu.add(jMenuItem5);
        final JMenuItem[] jMenuItemArray = new JMenuItem[]{jMenuItem, jMenuItem2, jMenuItem3, jMenuItem4, jMenuItem5};
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TransferRecord[] transferRecordArray;
                for (TransferRecord transferRecord : transferRecordArray = TransferMainTab.this.getSelectedRecords()) {
                    if (!TransferMainTab.this.monitor.save(transferRecord)) break;
                }
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TransferRecord[] transferRecordArray;
                for (TransferRecord transferRecord : transferRecordArray = TransferMainTab.this.getSelectedRecords()) {
                    TransferMainTab.this.monitor.open(transferRecord);
                }
            }
        });
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TransferRecord[] transferRecordArray;
                for (TransferRecord transferRecord : transferRecordArray = TransferMainTab.this.getSelectedRecords()) {
                    String string;
                    File file = TransferMainTab.this.monitor.getFileFromRecord(transferRecord);
                    try {
                        string = file.getCanonicalPath();
                    }
                    catch (Exception exception) {
                        string = file.getAbsolutePath();
                    }
                    StringSelection stringSelection = new StringSelection(string);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(stringSelection, null);
                }
            }
        });
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TransferRecord[] transferRecordArray;
                for (TransferRecord transferRecord : transferRecordArray = TransferMainTab.this.getSelectedRecords()) {
                    if (!transferRecord.isResumable()) continue;
                    String[] stringArray = new String[]{"request", "get", "fullpath=" + transferRecord.getRemote(), "bytes=" + (transferRecord.getSize() - transferRecord.getTransfered()), "offset=" + transferRecord.getTransfered(), "host=" + TransferMainTab.this.monitor.getTarget().getId()};
                    TransferMainTab.this.core.internalCommand(new InternalCommandCallback(){

                        public void taskingRecieved(List<String> list, Object object) {
                        }

                        public void taskingExecuted(Object object, Object object2) {
                        }

                        public void taskingRejected(Object object, Object object2) {
                        }
                    }, stringArray);
                }
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TransferMainTab.this.monitor.saveAll(TransferMainTab.this.getSelectedRecords());
            }
        });
        this.getTable.addMouseListener((MouseListener)new MousePopup(){

            protected void maybePopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    TransferRecord[] transferRecordArray;
                    int n = TransferMainTab.this.getTable.rowAtPoint(mouseEvent.getPoint());
                    if (n < 0 || n >= TransferMainTab.this.getTable.getRowCount()) {
                        return;
                    }
                    int[] nArray = TransferMainTab.this.getTable.getSelectedRows();
                    boolean bl = false;
                    int[] objectArray = nArray;
                    int n2 = objectArray.length;
                    for (int i = 0; i < n2; ++i) {
                        int n3 = objectArray[i];
                        if (n3 != n) continue;
                        bl = true;
                    }
                    if (bl && nArray.length > 1) {
                        jMenuItem2.setEnabled(true);
                    } else {
                        TransferMainTab.this.getTable.getSelectionModel().clearSelection();
                        TransferMainTab.this.getTable.getSelectionModel().addSelectionInterval(n, n);
                    }
                    for (JMenuItem jMenuItem6 : jMenuItemArray) {
                        jMenuItem6.setEnabled(false);
                    }
                    for (TransferRecord transferRecord : transferRecordArray = TransferMainTab.this.getSelectedRecords()) {
                        if (transferRecord.isResumable()) {
                            jMenuItem5.setEnabled(true);
                        }
                        if (!transferRecord.getDirection().equals((Object)TransferDirection.GET) || transferRecord.getState().equals((Object)TransferState.STARTED)) continue;
                        jMenuItem4.setEnabled(true);
                        if (jMenuItem.isEnabled()) {
                            jMenuItem2.setEnabled(true);
                        }
                        jMenuItem.setEnabled(true);
                        jMenuItem3.setEnabled(true);
                    }
                    TransferMainTab.this.contextMenu.show(TransferMainTab.this.getTable, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.getTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n = TransferMainTab.this.getTable.rowAtPoint(mouseEvent.getPoint());
                    if (n < 0 || n >= TransferMainTab.this.getTable.getRowCount()) {
                        return;
                    }
                    TransferRecord transferRecord = (TransferRecord)TransferRecord.class.cast(TransferMainTab.this.sorter.getValueAt(n, TransferMonitorColumns.SIZE.ordinal()));
                    TransferMainTab.this.monitor.open(transferRecord);
                }
            }
        });
        columnHidingModel.hide((Enum)TransferMonitorColumns.TYPE);
        columnHidingModel.hide((Enum)TransferMonitorColumns.ID);
        columnHidingModel.hide((Enum)TransferMonitorColumns.TIME_ACCESSED);
        columnHidingModel.hide((Enum)TransferMonitorColumns.TIME_CREATED);
        columnHidingModel.hide((Enum)TransferMonitorColumns.TIME_MODIFIED);
    }

    private TransferRecord[] getSelectedRecords() {
        int[] nArray = this.getTable.getSelectedRows();
        TransferRecord[] transferRecordArray = new TransferRecord[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            transferRecordArray[i] = (TransferRecord)TransferRecord.class.cast(this.sorter.getValueAt(nArray[i], TransferMonitorColumns.SIZE.ordinal()));
        }
        return transferRecordArray;
    }

    @Override
    public boolean allowNewInstance(Class<?> clazz) {
        return false;
    }

    public JComponent initialFocus() {
        return null;
    }

    public Alignment getAlignment() {
        return Alignment.LEFT;
    }

    public boolean isClosable() {
        return false;
    }

    public boolean isHideable() {
        return false;
    }

    public boolean isUnhideable() {
        return true;
    }

    public void commandEnded(Task task) {
        this.getMonitorModel.commandEnded(task);
    }

    private void setColumnWidth(TransferMonitorColumns transferMonitorColumns, String string, boolean bl, boolean bl2) {
        JLabel jLabel = new JLabel(string);
        if (bl) {
            try {
                jLabel.setIcon(ImageManager.getIcon((String)"images/up.png", (Dimension)this.core.getLabelImageSize()));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        TableColumn tableColumn = this.getTable.getColumnModel().getColumn(transferMonitorColumns.ordinal());
        int n = jLabel.getPreferredSize().width;
        tableColumn.setWidth(n);
        if (bl2) {
            tableColumn.setMinWidth(n);
            tableColumn.setMaxWidth(n);
        }
    }

    private void setColumnWidths() {
        this.setColumnWidth(TransferMonitorColumns.ID, " 88 ", true, true);
        this.setColumnWidth(TransferMonitorColumns.STATE, " state ", true, true);
        this.setColumnWidth(TransferMonitorColumns.SIZE, "0000000000 of 0000000000  ", true, false);
    }

    public void addRecord(TransferRecord transferRecord) {
        this.getMonitorModel.addRecord(transferRecord);
    }

    public int getNext() {
        return this.getMonitorModel.getNext();
    }

    public TransferRecord getRecord(int n) {
        return this.getMonitorModel.getRecord(n);
    }

    public void recordChanged(TransferRecord transferRecord) {
        this.getMonitorModel.recordChanged(transferRecord);
    }
}

