/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin;

import ddb.detach.AbstractTabbable;
import ddb.detach.Tabbable;
import ddb.detach.TabbableOption;
import ddb.detach.Workbench;
import ddb.dsz.annotations.DszDescription;
import ddb.dsz.annotations.DszDetachable;
import ddb.dsz.annotations.DszHideable;
import ddb.dsz.annotations.DszLive;
import ddb.dsz.annotations.DszLogo;
import ddb.dsz.annotations.DszName;
import ddb.dsz.annotations.DszUserStartable;
import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.command.GuiCommand;
import ddb.dsz.core.connection.ConnectionChangeEvent;
import ddb.dsz.core.connection.events.HostEvent;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.internalcommand.InternalCommandCallback;
import ddb.dsz.core.internalcommand.InternalCommandHandler;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.plugin.Plugin;
import ddb.util.proxy.DszProxyHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DszLive(live=false, replay=false)
@DszLogo(value="images/PluginAdapter/gnome-unknown.png")
@DszDescription(value="Abstract implementation of a Plugin")
@DszName(value="AbstractPlugin")
@DszUserStartable(value=true)
public abstract class AbstractPlugin
extends AbstractTabbable
implements Plugin,
Comparable<Tabbable>,
InternalCommandHandler {
    protected final PropertyChangeListener contentsChanged = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AbstractPlugin.this.fireContentsChanged();
        }
    };
    protected final PropertyChangeListener contentsChangedRequestFocus = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AbstractPlugin.this.fireContentsChangedRequestFocus();
        }
    };
    private JComponent display;
    private JComponent fullDisplay;
    protected CoreController core;
    protected JComponent parentDisplay;
    protected Dimension prefferedSize;
    private boolean userClosable;
    private boolean canClose;
    private boolean localEvents;
    protected boolean detached;
    protected JMenuBar menuBar;
    protected Collection<Task> tasksExamined;
    protected HostInfo target = null;
    boolean showStatus = true;
    String identifier = null;
    protected boolean onlyLive = false;
    private Predicate evaluateGuiCommand = PredicateUtils.falsePredicate();
    protected JLabel hostRenderer;

    protected synchronized JComponent getTabbableSpecificRenderComponent() {
        if (this.hostRenderer == null) {
            this.hostRenderer = new JLabel("--");
            this.hostRenderer.setHorizontalTextPosition(0);
        }
        return this.hostRenderer;
    }

    protected void setOnlyLive(boolean bl) {
        this.onlyLive = bl;
    }

    private final void parseArguments(List<String> list) {
        if (list == null) {
            return;
        }
        for (String string : list) {
            String[] stringArray = string.split("=", 2);
            if (stringArray.length == 2) {
                this.parseArgument(stringArray[0], stringArray[1]);
                continue;
            }
            this.parseArgument(stringArray[0], null);
        }
    }

    protected final boolean parseArgument(String string, String string2) {
        return this.parseArgument2(string, string2);
    }

    protected boolean parseArgument2(String string, String string2) {
        return false;
    }

    public AbstractPlugin() {
        DszHideable dszHideable;
        DszLogo dszLogo;
        this.tasksExamined = new Vector<Task>();
        this.display = new JPanel();
        this.display.setLayout(new FlowLayout());
        this.display.add(new JLabel("No display specified"));
        super.setName(new String("AbstractPlugin"));
        this.prefferedSize = new Dimension(500, 250);
        this.menuBar = null;
        this.userClosable = true;
        this.canClose = true;
        this.localEvents = false;
        DszDescription dszDescription = this.getClass().getAnnotation(DszDescription.class);
        if (dszDescription != null) {
            super.setShortDescription(dszDescription.value());
        }
        if ((dszLogo = this.getClass().getAnnotation(DszLogo.class)) != null) {
            this.setLogo(this.getClass().getAnnotation(DszLogo.class).value());
        }
        if ((dszHideable = this.getClass().getAnnotation(DszHideable.class)) == null) {
            super.setHideable(true);
            super.setUnhideable(true);
        } else {
            super.setHideable(dszHideable.hide());
            super.setUnhideable(dszHideable.unhide());
        }
        DszDetachable dszDetachable = this.getClass().getAnnotation(DszDetachable.class);
        if (dszDetachable != null) {
            super.setDetachable(dszDetachable.value());
        } else {
            super.setDetachable(true);
        }
        this.fullDisplay = new JPanel(new BorderLayout());
        this.fullDisplay.add((Component)this.display, "Center");
    }

    protected void setDisplay(JComponent jComponent) {
        this.fullDisplay.remove(this.display);
        this.display = jComponent;
        this.fullDisplay.add((Component)this.display, "Center");
        super.registerDisplay(this.fullDisplay);
    }

    @Override
    public final int init(CoreController coreController, JComponent jComponent, List<String> list) {
        int n;
        coreController.logEvent(Level.FINEST, "Executing init() in " + this.getName());
        this.core = coreController;
        this.parentDisplay = jComponent;
        this.core.setupKeyBindings(this.fullDisplay);
        if (this.getLogo() != null) {
            this.setLogo(this.getLogo());
        }
        if ((n = this.init2()) != 0) {
            return n;
        }
        this.parseArguments(list);
        return this.postParseArguments();
    }

    protected int postParseArguments() {
        return 0;
    }

    protected int init2() {
        return 0;
    }

    public Dimension getPreferredSize() {
        return this.prefferedSize;
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    @Override
    public void commandEventReceived(CommandEvent commandEvent) {
        switch (commandEvent.getType()) {
            case STARTED: {
                this.commandStarted(commandEvent);
                break;
            }
            case SET_FLAGS: {
                this.commandSetFlags(commandEvent);
                break;
            }
            case START_PROMPT: {
                this.commandStartPrompt(commandEvent);
                break;
            }
            case STOP_PROMPT: {
                this.commandStopPrompt(commandEvent);
                break;
            }
            case OUTPUT: {
                this.commandOutput(commandEvent);
                break;
            }
            case PAUSED: {
                this.commandPaused(commandEvent);
                break;
            }
            case ENDED: {
                this.commandEnded(commandEvent);
                break;
            }
            case HELP: {
                this.commandHelp(commandEvent);
                break;
            }
            case INFO: {
                this.commandInfo(commandEvent);
                break;
            }
            case COMMANDLISTUPDATED: {
                this.commandList(commandEvent);
                break;
            }
            case BACKGROUNDED: {
                this.commandBackgrounded(commandEvent);
                break;
            }
            case GUICOMMAND: {
                this.commandGui((GuiCommand)GuiCommand.class.cast(commandEvent));
                break;
            }
        }
    }

    protected void commandList(CommandEvent commandEvent) {
    }

    protected void commandStarted(CommandEvent commandEvent) {
    }

    protected void commandSetFlags(CommandEvent commandEvent) {
    }

    protected void commandStartPrompt(CommandEvent commandEvent) {
    }

    protected void commandStopPrompt(CommandEvent commandEvent) {
    }

    protected void commandOutput(CommandEvent commandEvent) {
    }

    protected void commandPaused(CommandEvent commandEvent) {
    }

    protected void commandEnded(CommandEvent commandEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void commandGui(GuiCommand guiCommand) {
        GuiCommand guiCommand2 = guiCommand;
        synchronized (guiCommand2) {
            if (guiCommand.isHandled()) {
                return;
            }
            if (!this.evaluateGuiCommand.evaluate((Object)guiCommand)) {
                return;
            }
            guiCommand.handled();
        }
        this.handleGuiCommand(guiCommand);
    }

    protected void setGuiCommandPredicate(Predicate predicate) {
        if (predicate == null) {
            predicate = PredicateUtils.falsePredicate();
        }
        this.evaluateGuiCommand = predicate;
    }

    protected void handleGuiCommand(GuiCommand guiCommand) {
    }

    protected void commandHelp(CommandEvent commandEvent) {
    }

    protected void commandInfo(CommandEvent commandEvent) {
    }

    protected void commandBackgrounded(CommandEvent commandEvent) {
    }

    @Override
    public final void fini() {
        this.fini2();
        this.core.logEvent(Level.FINEST, "Executing fini() in " + this.getName());
        this.target = null;
        super.fini();
    }

    protected void fini2() {
    }

    public void contentsChanged() {
        this.fireContentsChanged();
    }

    public boolean allowNewInstance(Class<?> clazz) {
        return true;
    }

    @Override
    public boolean isUserClosable() {
        return this.userClosable;
    }

    @Override
    public boolean isClosable() {
        return this.canClose;
    }

    @Override
    public void setUserClosable(boolean bl) {
        this.userClosable = bl;
    }

    @Override
    public void setCanClose(boolean bl) {
        this.canClose = bl;
    }

    @Override
    public void receivedFocus() {
    }

    @Override
    public boolean handlesPromptsForTask(Task task, int n) {
        return false;
    }

    @Override
    public boolean caresAboutLocalEvents() {
        return this.localEvents;
    }

    protected void setCareAboutLocalEvents(boolean bl) {
        this.localEvents = bl;
    }

    @Override
    public void connectionChanged(ConnectionChangeEvent connectionChangeEvent) {
        HostEvent hostEvent;
        HostInfo hostInfo;
        if (connectionChangeEvent instanceof HostEvent && (hostInfo = (hostEvent = (HostEvent)connectionChangeEvent).getHost()) != null && hostInfo.sameHost(this.target)) {
            this.target = hostInfo;
            if (this.workbench != null) {
                this.workbench.enqueAction((Enum)Workbench.WorkbenchAction.RENAMETAB, new Object[]{this, this.getName()});
            }
        }
    }

    @Override
    public void setDetachable(boolean bl) {
        super.setDetachable(bl);
    }

    @Override
    public void setHideable(boolean bl) {
        super.setHideable(bl);
    }

    @Override
    public void setLogo(String string) {
        this.setLogo(string, this.core != null ? this.core.getTabImageSize() : new Dimension(32, 32));
    }

    @Override
    public void setShortDescription(String string) {
        super.setShortDescription(string);
    }

    @Override
    public void setUnhideable(boolean bl) {
        super.setUnhideable(bl);
    }

    @Override
    public TabbableOption getRegularOptions() {
        return null;
    }

    @Override
    public TabbableOption getStaticOptions() {
        return null;
    }

    public void execute(Runnable runnable) {
        this.core.execute(runnable);
    }

    public JComponent getDefaultElement() {
        return null;
    }

    @Override
    public boolean caresAboutRepeatedEvents() {
        return true;
    }

    @Override
    public Comparator<CommandEvent> getComparator() {
        return null;
    }

    @Override
    public void setTarget(HostInfo hostInfo) {
        this.setHost(hostInfo);
    }

    protected void setHost(HostInfo hostInfo) {
        this.target = hostInfo;
        String string = "";
        Color color = Color.YELLOW;
        Color color2 = Color.CYAN;
        if (hostInfo == null) {
            color = Color.BLACK;
            color2 = null;
        } else {
            if (hostInfo.isLocal()) {
                color2 = Color.RED;
                color = Color.WHITE;
            } else {
                color2 = null;
                color = Color.BLACK;
            }
            string = hostInfo.getId();
        }
        this.status.setHost(string, color, color2);
        this.status.notifyObservers();
        this.setDisplayedName();
    }

    @Override
    public boolean runInternalCommand(List<String> list, InternalCommandCallback internalCommandCallback) {
        return false;
    }

    @Override
    public boolean runInternalCommand(List<String> list, TaskId taskId, InternalCommandCallback internalCommandCallback) {
        return false;
    }

    public String getDockedTitle() {
        String string = super.getDockedTitle();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (AbstractPlugin.this.hostRenderer != null) {
                    if (AbstractPlugin.this.target == null) {
                        AbstractPlugin.this.hostRenderer.setText("");
                    } else {
                        if (!AbstractPlugin.this.target.isLocal() && AbstractPlugin.this.target.isConnected()) {
                            AbstractPlugin.this.hostRenderer.setForeground(Color.BLACK);
                        } else {
                            AbstractPlugin.this.hostRenderer.setForeground(Color.RED);
                        }
                        AbstractPlugin.this.hostRenderer.setText(AbstractPlugin.this.target.isConnected() ? AbstractPlugin.this.target.getId() : "Disconnected");
                    }
                }
            }
        });
        return string;
    }

    public String getDetachedTitle() {
        String string = super.getDetachedTitle();
        String string2 = this.core.getTitle();
        if (this.target != null) {
            string = String.format("%s - %s", string, this.target.getId());
        }
        if (string2 != null) {
            string = String.format("%s [%s]", string, string2);
        }
        return string;
    }

    @Override
    public final String getClazz() {
        return this.getClass().getName();
    }

    @Override
    public final void setIdentifier(String string) {
        this.identifier = string;
    }

    @Override
    public final String getIdentifier() {
        if (this.identifier == null) {
            return this.getClass().getName();
        }
        return this.identifier;
    }

    @Override
    public boolean isShowStatus() {
        return this.showStatus;
    }

    @Override
    public void setShowStatus(boolean bl) {
        this.showStatus = false;
    }

    @Override
    public HostInfo getTarget() {
        return this.target;
    }

    @Override
    public boolean canSetTarget() {
        return true;
    }

    public final boolean equals(Object object) {
        return super.equals(DszProxyHandler.Unwrap((Object)object));
    }

    public int hashCode() {
        return super.hashCode();
    }
}

