/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.multitarget;

import ddb.detach.Tabbable;
import ddb.detach.TabbableFrame;
import ddb.detach.TabbablePopupListener;
import ddb.detach.Workbench;
import ddb.dsz.plugin.Plugin;
import ddb.dsz.plugin.multitarget.MultipleTargetPlugin;
import ddb.dsz.plugin.multitarget.MultipleTargetPopupListener;
import ddb.dsz.plugin.multitarget.MultipleTargetPopupMenu;
import ddb.dsz.plugin.multitarget.SingleTargetInterface;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public class MultipleTargetWorkbench
extends Workbench {
    protected final MultipleTargetPlugin owner;

    public MultipleTargetWorkbench(MultipleTargetPlugin multipleTargetPlugin) {
        this.owner = multipleTargetPlugin;
        this.init();
    }

    private void init() {
        this.actionHandler.put(MultipleTargetWorkbenchAction.STOPPLUGIN, StopPlugin.class);
        this.actionHandler.put(Workbench.WorkbenchAction.ADDNEWTAB, AddNewTab.class);
        this.actionHandler.put(Workbench.WorkbenchAction.SETSELECTEDTAB, SetSelectedTab.class);
    }

    public String getTitleAt(int n) {
        Tabbable tabbable;
        Component component = this.getComponentAt(n);
        if (component != null && (tabbable = this.getTabbableForDisplay(component)) != null) {
            return tabbable.getName();
        }
        return super.getTitleAt(n);
    }

    public JPopupMenu getMenu() {
        return new MultipleTargetPopupMenu(this, this.owner, this.owner.getCoreController());
    }

    public TabbablePopupListener getTabPopupListener() {
        return new MultipleTargetPopupListener(this);
    }

    public JComponent getDefaultElement() {
        Component component = this.getSelectedComponent();
        if (component == null) {
            return null;
        }
        Tabbable tabbable = this.getTabbableForDisplay(component);
        if (tabbable != null) {
            return tabbable.getDefaultElement();
        }
        return null;
    }

    protected Dimension getDefaultSize() {
        Dimension dimension = new Dimension(640, 480);
        for (int i = 0; i < this.pluginsInOrder.size(); ++i) {
            try {
                Tabbable tabbable = (Tabbable)this.pluginsInOrder.get(i);
                if (tabbable == null) continue;
                dimension.height = Math.max(dimension.height, tabbable.getPreferredSize().height);
                dimension.width = Math.max(dimension.width, tabbable.getPreferredSize().width);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dimension;
    }

    protected class SetSelectedTab
    extends Workbench.SetSelectedTab {
        public SetSelectedTab(Tabbable tabbable) {
            super((Workbench)MultipleTargetWorkbench.this, tabbable);
        }

        public void runTask() {
            super.runTask();
        }
    }

    protected class AddNewTab
    extends Workbench.AddNewTab {
        public AddNewTab(Tabbable tabbable) {
            super((Workbench)MultipleTargetWorkbench.this, tabbable);
        }

        public void runTask() {
            super.runTask();
        }
    }

    protected class CloseTab
    extends Workbench.CloseTab {
        public CloseTab(Tabbable tabbable) {
            super((Workbench)MultipleTargetWorkbench.this, tabbable);
        }

        public void runTask() {
            MultipleTargetWorkbench.this.owner.destroy((SingleTargetInterface)SingleTargetInterface.class.cast(this.tab));
            MultipleTargetWorkbench.this.invokeAction((Enum)Workbench.WorkbenchAction.REMOVETAB, new Object[]{this.tab});
            MultipleTargetWorkbench.this.invokeAction((Enum)Workbench.WorkbenchAction.HIDETAB, new Object[]{this.tab});
            MultipleTargetWorkbench.this.invokeAction(MultipleTargetWorkbenchAction.STOPPLUGIN, new Object[]{this.tab});
            this.tab.hideFrame();
        }
    }

    protected class StopPlugin
    extends Workbench.DirectTabTask {
        Thread th;
        boolean started;
        boolean killed;

        public StopPlugin(SingleTargetInterface singleTargetInterface) {
            super((Workbench)MultipleTargetWorkbench.this, (Tabbable)singleTargetInterface);
            this.th = null;
            this.started = false;
            this.killed = false;
        }

        public void runTask() {
            if (!this.started) {
                this.started = true;
                this.th = new Thread(new Runnable(){

                    public void run() {
                        SingleTargetInterface singleTargetInterface = (SingleTargetInterface)StopPlugin.this.tab;
                        MultipleTargetWorkbench.this.owner.getCoreController().logEvent(Level.FINEST, "Stopping plugin: " + singleTargetInterface.toString());
                        singleTargetInterface.fini();
                        StopPlugin.this.killed = true;
                    }
                }, "Stopping " + this.tab.toString());
                this.th.setDaemon(true);
                this.th.setPriority(1);
                this.th.start();
                EventQueue.invokeLater((Runnable)((Object)this));
                return;
            }
            if (!this.killed) {
                try {
                    TimeUnit.MILLISECONDS.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                EventQueue.invokeLater((Runnable)((Object)this));
                return;
            }
            Plugin plugin = (Plugin)this.tab;
            if (plugin.getFrame() != null) {
                TabbableFrame tabbableFrame = plugin.getFrame();
                plugin.setFrame(null);
                tabbableFrame.setVisible(false);
                tabbableFrame.dispose();
            }
            MultipleTargetWorkbench.this.enqueAction((Enum)Workbench.WorkbenchAction.REMOVETAB, new Object[]{plugin});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MultipleTargetWorkbenchAction {
        STOPPLUGIN;

    }
}

