/*
 * Decompiled with CFR 0.152.
 */
package pcremoteconfiguration.autocomplete;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import pcremoteconfiguration.autocomplete.AutoCompleteDocument;
import pcremoteconfiguration.autocomplete.CompletionService;

public class CompletionSample
implements Runnable {
    @Override
    public void run() {
        NameService nameService = new NameService();
        JTextField input = new JTextField(20);
        AutoCompleteDocument autoCompleteDocument = new AutoCompleteDocument(nameService, input);
        input.setDocument(autoCompleteDocument);
        JFrame frame = new JFrame("Autocompletion sample");
        frame.setDefaultCloseOperation(3);
        JComponent contentPane = (JComponent)frame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)input, "South");
        contentPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new CompletionSample());
    }

    private static class NameService
    implements CompletionService<String> {
        private List<String> data = Arrays.asList("Apple", "Orange", "Banana", "Apricote");

        @Override
        public String autoComplete(String startsWith) {
            String hit = null;
            for (String o : this.data) {
                if (!o.startsWith(startsWith)) continue;
                if (hit == null) {
                    hit = o;
                    continue;
                }
                hit = null;
                break;
            }
            return hit;
        }
    }
}

