/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.requesthandler.closures;

import ddb.dsz.core.command.IdCallback;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.controller.DispatcherException;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.plugin.requesthandler.RequestReceiver;
import ddb.dsz.plugin.requesthandler.predicate.SpawnTerminalPredicate;
import ddb.dsz.plugin.requesthandler.requests.RequestedOperation;
import ddb.dsz.plugin.requesthandler.tranformers.CommandTransformer;
import ddb.dsz.plugin.requesthandler.tranformers.GetActionTransformer;
import java.util.Vector;
import org.apache.commons.collections.Closure;

public class ExecutionClosure
implements Closure {
    protected CoreController core;
    protected RequestReceiver recv;

    public static final Closure getInstance(RequestReceiver requestReceiver, CoreController coreController) {
        return new ExecutionClosure(requestReceiver, coreController);
    }

    protected ExecutionClosure(RequestReceiver requestReceiver, CoreController coreController) {
        this.core = coreController;
        this.recv = requestReceiver;
    }

    public void execute(Object object) {
        final RequestedOperation requestedOperation = (RequestedOperation)RequestedOperation.class.cast(object);
        String string = CommandTransformer.getInstance().transform(requestedOperation);
        if (string == null) {
            return;
        }
        if (requestedOperation.getData("host") != null) {
            string = String.format("dst=%s %s", requestedOperation.getData("host"), string);
        }
        if (SpawnTerminalPredicate.getInstance().evaluate(requestedOperation.getKey())) {
            if (this.core.internalCommand(null, new String[]{"terminal", String.format("guiflag=focus %s", string)})) {
                return;
            }
            Vector<String> vector = new Vector<String>();
            vector.add(String.format("-cmd=%s", string));
            try {
                this.core.startNewPlugin(Class.forName(GetActionTransformer.getInstance().getTerminalPath(), false, ExecutionClosure.class.getClassLoader()), "Terminal", vector, false, false);
                this.recv.sendStarted(requestedOperation.getId(), null, null);
                if (requestedOperation.getCallback() != null) {
                    requestedOperation.getCallback().taskingExecuted((Object)requestedOperation.getId(), null);
                    requestedOperation.setCallback(null);
                }
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
        try {
            this.core.startCommand(string, new IdCallback(){

                public void idAcquired(TaskId taskId, Object object) {
                    if (!requestedOperation.isLocal()) {
                        ExecutionClosure.this.recv.registerRemoteCommand(taskId);
                    }
                    requestedOperation.setTaskId(taskId);
                    ExecutionClosure.this.recv.sendStarted(requestedOperation.getId(), taskId, null);
                    if (requestedOperation.getCallback() != null) {
                        requestedOperation.getCallback().taskingExecuted((Object)requestedOperation.getId(), (Object)taskId);
                        requestedOperation.setCallback(null);
                    }
                }
            }, null, null);
        }
        catch (DispatcherException dispatcherException) {
            dispatcherException.printStackTrace();
        }
    }
}

