/*
 * Decompiled with CFR 0.152.
 */
package ddb.bcb;

import ddb.bcb.BreadcrumbBar;
import ddb.bcb.BreadcrumbBarCallBack;
import ddb.bcb.BreadcrumbItem;
import ddb.bcb.BreadcrumbItemChoices;
import java.io.File;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;

public class BreadcrumbFileSelector
extends BreadcrumbBar {
    protected FileSystemView fsv = FileSystemView.getFileSystemView();
    protected boolean useNativeIcons;

    public BreadcrumbFileSelector() {
        this(true);
    }

    public BreadcrumbFileSelector(boolean bl) {
        super(null, ":", null);
        this.useNativeIcons = bl;
        this.callback = new DirCallback();
        File[] fileArray = File.listRoots();
        BreadcrumbItem[] breadcrumbItemArray = new BreadcrumbItem[fileArray.length];
        int n = 0;
        for (File file : fileArray) {
            String string = this.fsv.getSystemDisplayName(file);
            if (string.length() == 0) {
                string = file.getAbsolutePath();
            }
            BreadcrumbItem breadcrumbItem = new BreadcrumbItem(new String[]{string, file.getAbsolutePath()});
            Icon icon = this.fsv.getSystemIcon(file);
            if (bl) {
                breadcrumbItem.setIcon(icon);
            }
            breadcrumbItemArray[n++] = breadcrumbItem;
        }
        this.pushChoices(new BreadcrumbItemChoices(breadcrumbItemArray));
    }

    public void setUseNativeIcons(boolean bl) {
        this.useNativeIcons = bl;
    }

    public FileSystemView getFileSystemView() {
        return this.fsv;
    }

    public class DirCallback
    implements BreadcrumbBarCallBack {
        protected BreadcrumbItemChoices getChoices(File file) {
            if (!file.exists()) {
                return new BreadcrumbItemChoices(new BreadcrumbItem[0]);
            }
            if (!file.isDirectory()) {
                return null;
            }
            LinkedList<BreadcrumbItem> linkedList = new LinkedList<BreadcrumbItem>();
            for (File object : file.listFiles()) {
                if (!object.isDirectory() || object.isHidden()) continue;
                BreadcrumbItem breadcrumbItem = new BreadcrumbItem(new String[]{object.getName(), object.getAbsolutePath()});
                if (BreadcrumbFileSelector.this.useNativeIcons) {
                    breadcrumbItem.setIcon(BreadcrumbFileSelector.this.fsv.getSystemIcon(object));
                }
                linkedList.addLast(breadcrumbItem);
            }
            Object[] objectArray = new BreadcrumbItem[linkedList.size()];
            int n = 0;
            for (BreadcrumbItem breadcrumbItem : linkedList) {
                objectArray[n++] = breadcrumbItem;
            }
            return new BreadcrumbItemChoices((BreadcrumbItem[])objectArray);
        }

        public BreadcrumbItemChoices getChoices(BreadcrumbItem[] breadcrumbItemArray) {
            if (breadcrumbItemArray == null) {
                File[] fileArray = File.listRoots();
                BreadcrumbItem[] breadcrumbItemArray2 = new BreadcrumbItem[fileArray.length];
                int n = 0;
                for (File file : fileArray) {
                    String string = BreadcrumbFileSelector.this.fsv.getSystemDisplayName(file);
                    if (string.length() == 0) {
                        string = file.getAbsolutePath();
                    }
                    BreadcrumbItem breadcrumbItem = new BreadcrumbItem(new String[]{string, file.getAbsolutePath()});
                    if (BreadcrumbFileSelector.this.useNativeIcons) {
                        breadcrumbItem.setIcon(BreadcrumbFileSelector.this.fsv.getSystemIcon(file));
                    }
                    breadcrumbItemArray2[n++] = breadcrumbItem;
                }
                return new BreadcrumbItemChoices(breadcrumbItemArray2);
            }
            if (breadcrumbItemArray.length == 0) {
                return null;
            }
            String string = breadcrumbItemArray[breadcrumbItemArray.length - 1].getValue()[1];
            File file = new File(string);
            return this.getChoices(file);
        }
    }
}

