/*
 * Decompiled with CFR 0.152.
 */
package ddb.bcb.ui;

import ddb.bcb.BreadcrumbBar;
import ddb.bcb.BreadcrumbBarEvent;
import ddb.bcb.BreadcrumbItem;
import ddb.bcb.BreadcrumbItemChoices;
import ddb.bcb.ui.BasicBreadcrumbParticleUI;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.LabelUI;

public class BreadcrumbParticle
extends JLabel
implements BreadcrumbBar.BreadcrumbBarElement {
    private BreadcrumbItem item = null;
    private ButtonModel model;
    protected BreadcrumbBar bar;
    private static final String uiClassID = "BreadcrumbParticleUI";

    public BreadcrumbParticle(BreadcrumbBar breadcrumbBar, BreadcrumbItem breadcrumbItem, int n) {
        this.bar = breadcrumbBar;
        this.setText(breadcrumbItem.getName());
        this.setIcon(breadcrumbItem.getIcon());
        if (breadcrumbItem.getValue().length > 1) {
            this.setName(breadcrumbItem.getValue()[1]);
        }
        this.setFocusable(true);
        this.item = breadcrumbItem;
        this.setHorizontalAlignment(10);
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.model = new DefaultButtonModel();
        this.model.setSelected(false);
        this.updateUI();
    }

    public int getIndex() {
        return this.item.getIndex();
    }

    public void validateElement() {
        BreadcrumbItem[] breadcrumbItemArray = this.bar.getPath();
        BreadcrumbItem[] breadcrumbItemArray2 = this.bar.getPath(this.item.getIndex());
        while (this.bar.getStack().size() > this.item.getIndex() + 1) {
            this.bar.pop();
        }
        BreadcrumbItemChoices breadcrumbItemChoices = this.bar.getCallback().getChoices(breadcrumbItemArray2);
        if (breadcrumbItemChoices != null) {
            this.bar.pushChoices(breadcrumbItemChoices);
        }
        this.bar.getUI().updateComponents();
        this.bar.fireBreadcrumbBarEvent(new BreadcrumbBarEvent(this.bar, 0, breadcrumbItemArray, this.bar.getPath()));
    }

    public void setUI(LabelUI labelUI) {
        super.setUI(labelUI);
    }

    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((LabelUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicBreadcrumbParticleUI());
        }
    }

    public LabelUI getUI() {
        return (LabelUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public BreadcrumbBar getBar() {
        return this.bar;
    }

    public ButtonModel getModel() {
        return this.model;
    }
}

