/*
 * Decompiled with CFR 0.152.
 */
package ddb.detach;

import ddb.actions.tabnav.NavigationDirection;
import ddb.detach.TabNavigationListener;
import ddb.detach.Tabbable;
import ddb.detach.TabbableWindowTabbifier;
import ddb.detach.Workbench;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class TabbableFrame
extends JFrame
implements FocusListener {
    protected Tabbable tab;
    protected Workbench bench;

    public TabbableFrame(Tabbable tabbable, Workbench workbench, Dimension dimension, Point point) {
        this.tab = tabbable;
        this.bench = workbench;
        this.setDefaultCloseOperation(0);
        this.addFocusListener(this);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(37, 128), NavigationDirection.PREVIOUS.getName());
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(39, 128), NavigationDirection.NEXT.getName());
        NavigationDirection.fill(new TabNavigationListener(){

            public void navigationActionPerformed(NavigationDirection navigationDirection, ActionEvent actionEvent) {
                TabbableFrame.this.bench.setCurrentTab(TabbableFrame.this.tab);
                super.navigationActionPerformed(navigationDirection, actionEvent);
            }
        }, this.getRootPane().getActionMap());
        JComponent jComponent = this.getStatusBar();
        this.setResizable(true);
        tabbable.setFrame(this);
        if (dimension == null) {
            dimension = tabbable.getPreferredSize();
        }
        this.addWindowListener(this.getWindowListener());
        dimension = this.cropSize(dimension);
        if (dimension != null) {
            this.setSize(dimension);
        } else {
            this.setSize(tabbable.getPreferredSize());
        }
        if (point != null) {
            this.setLocation(new Point(this.getLocation().x + point.x, this.getLocation().y + point.y));
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)tabbable.getDisplay(), "Center");
        JPanel jPanel = new JPanel(new BorderLayout());
        if (jComponent != null) {
            jPanel.add((Component)jComponent, "Center");
        }
        this.getContentPane().add((Component)jPanel, "South");
        this.setTitle(tabbable.getDetachedTitle());
        tabbable.generateFloatingTitle();
    }

    protected JComponent getStatusBar() {
        return null;
    }

    protected WindowListener getWindowListener() {
        return new TabbableWindowTabbifier(this.tab, this.bench);
    }

    public void setDisplay(JComponent jComponent) {
        this.getContentPane().add((Component)jComponent, "Center");
    }

    private Dimension cropSize(Dimension dimension) {
        dimension.height = this.cropInteger(dimension.height, 150, 1900);
        dimension.width = this.cropInteger(dimension.width, 250, 1100);
        return dimension;
    }

    private int cropInteger(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.bench.setCurrentTab(this.tab);
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public Tabbable getTabbable() {
        return this.tab;
    }

    public Workbench getWorkbench() {
        return this.bench;
    }
}

