/*
 * Decompiled with CFR 0.152.
 */
package ddb.listeners;

import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class LimitLinesDocumentListener
implements DocumentListener {
    private int maximumLines;
    private boolean isRemoveFromStart;

    public LimitLinesDocumentListener(int n) {
        this(n, true);
    }

    public LimitLinesDocumentListener(int n, boolean bl) {
        this.maximumLines = n;
        this.isRemoveFromStart = bl;
    }

    public int getLimitLines() {
        return this.maximumLines;
    }

    public void setLimitLiens(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Maximum lines must be greater than 0");
        }
        this.maximumLines = n;
    }

    public void insertUpdate(final DocumentEvent documentEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LimitLinesDocumentListener.this.removeLines(documentEvent);
            }
        });
    }

    public void removeUpdate(DocumentEvent documentEvent) {
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    private void removeLines(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        Element element = document.getDefaultRootElement();
        while (element.getElementCount() > this.maximumLines) {
            int n = element.getElementCount() - this.maximumLines + (int)((double)this.maximumLines * 0.3);
            if (this.isRemoveFromStart) {
                this.removeFromStart(document, element, n);
                continue;
            }
            this.removeFromEnd(document, element, n);
        }
    }

    private void removeFromStart(Document document, Element element, int n) {
        Element element2 = element.getElement(n);
        int n2 = element2.getEndOffset();
        try {
            document.remove(0, n2);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    private void removeFromEnd(Document document, Element element, int n) {
        Element element2 = element.getElement(element.getElementCount() - 1 - n);
        int n2 = element2.getStartOffset();
        int n3 = element2.getEndOffset();
        try {
            document.remove(n2 - 1, n3 - n2);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }
}

