/*
 * Decompiled with CFR 0.152.
 */
package ddb.splash;

import ddb.GuiConstants;
import ddb.imagemanager.ImageManager;
import java.awt.EventQueue;
import java.util.List;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;

public class SplashScreen2
extends JFrame {
    public static final Object SHOW = new Object();
    public static final Object HIDE = new Object();
    List<MajorStage> stages = new Vector<MajorStage>();
    private JLabel bannerImage;
    private JProgressBar majorProgress;
    private JProgressBar minorProgress;
    private JButton skip;
    private JLabel stageIcon;
    private JLabel state;

    public void begin() {
        SwingWorker<Object, Object> swingWorker = new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                this.publish(SHOW);
                this.publish(SplashScreen2.this.stages.size());
                for (MajorStage majorStage : SplashScreen2.this.stages) {
                    this.publish(majorStage);
                    majorStage.run();
                    for (MinorStage minorStage : majorStage.getStages()) {
                        this.publish(minorStage);
                        minorStage.run();
                    }
                }
                this.publish(HIDE);
                return HIDE;
            }

            @Override
            protected void process(List<Object> list) {
                if (list == null) {
                    return;
                }
                for (Object object : list) {
                    Object object2;
                    if (object == SHOW) {
                        SplashScreen2.this.setVisible(true);
                        return;
                    }
                    if (object == HIDE) {
                        SplashScreen2.this.setVisible(false);
                        SplashScreen2.this.dispose();
                        return;
                    }
                    if (object instanceof MajorStage) {
                        object2 = (MajorStage)object;
                        if (((MajorStage)object2).getStages().size() == 0) {
                            SplashScreen2.this.minorProgress.setIndeterminate(true);
                        } else {
                            SplashScreen2.this.minorProgress.setIndeterminate(false);
                            SplashScreen2.this.minorProgress.setValue(0);
                            SplashScreen2.this.minorProgress.setMaximum(((MajorStage)object2).getStages().size() + 1);
                        }
                        SplashScreen2.this.majorProgress.setValue(SplashScreen2.this.majorProgress.getValue() + 1);
                        SplashScreen2.this.state.setText(((MajorStage)object2).name);
                        SplashScreen2.this.stageIcon.setIcon(ImageManager.getIcon(((MajorStage)object2).icon, ImageManager.SIZE64));
                        continue;
                    }
                    if (object instanceof MinorStage) {
                        object2 = (MinorStage)object;
                        if (((MinorStage)object2).name != null) {
                            SplashScreen2.this.state.setText(((MinorStage)object2).name);
                        }
                        SplashScreen2.this.minorProgress.setValue(SplashScreen2.this.minorProgress.getValue() + 1);
                        SplashScreen2.this.state.setText(((MinorStage)object2).name);
                        continue;
                    }
                    if (!(object instanceof Integer)) continue;
                    SplashScreen2.this.majorProgress.setMaximum((Integer)object);
                }
            }
        };
        swingWorker.execute();
        if (!EventQueue.isDispatchThread()) {
            try {
                swingWorker.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public SplashScreen2(String string) {
        this.initComponents();
        GuiConstants.locate(this, 0.5, 0.25);
        this.setTitle(string);
        this.skip.setVisible(false);
    }

    public void addStage(MajorStage majorStage) {
        this.stages.add(majorStage);
    }

    public void setStageIcon(String string) {
        this.stageIcon.setIcon(ImageManager.getIcon(string, ImageManager.SIZE64));
    }

    public void setState(String string) {
        this.state.setText(string);
    }

    public void setSkipVisibility(boolean bl) {
        this.skip.setVisible(bl);
    }

    public void setMinorProgress(int n, int n2, int n3) {
        this.setProgress(this.minorProgress, n, n2, n3);
    }

    public void setMajorProgress(int n, int n2, int n3) {
        this.setProgress(this.majorProgress, n, n2, n3);
    }

    public void setMinorIndeterminate(boolean bl) {
        this.minorProgress.setIndeterminate(bl);
    }

    public void setMajorIndeterminate(boolean bl) {
        this.majorProgress.setIndeterminate(bl);
    }

    private void setProgress(JProgressBar jProgressBar, int n, int n2, int n3) {
        jProgressBar.setMinimum(n);
        jProgressBar.setMaximum(n2);
        jProgressBar.setValue(n3);
        jProgressBar.setIndeterminate(false);
    }

    private void initComponents() {
        this.bannerImage = new JLabel();
        this.majorProgress = new JProgressBar();
        this.minorProgress = new JProgressBar();
        this.state = new JLabel();
        this.stageIcon = new JLabel();
        this.skip = new JButton();
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.setUndecorated(true);
        this.bannerImage.setIcon(new ImageIcon(this.getClass().getResource("/images/earth.png")));
        this.state.setText("State");
        this.stageIcon.setIcon(new ImageIcon(this.getClass().getResource("/images/3d.png")));
        this.skip.setText("Skip");
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bannerImage).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.stageIcon).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.minorProgress, -1, 251, Short.MAX_VALUE).addComponent(this.majorProgress, -1, 251, Short.MAX_VALUE).addComponent(this.state, -1, 251, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.skip).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.bannerImage).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.stageIcon).addGroup(groupLayout.createSequentialGroup().addComponent(this.state).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.majorProgress, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.minorProgress, -2, -1, -2))).addComponent(this.skip, -1, 64, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    public abstract class MinorStage {
        String name = null;

        public MinorStage() {
        }

        public MinorStage(String string) {
            this.name = string;
        }

        public abstract void run();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class MajorStage {
        String name = null;
        String icon = null;

        public MajorStage() {
        }

        public MajorStage(String string, String string2) {
            this.name = string;
            this.icon = string2;
        }

        public abstract List<MinorStage> getStages();

        public void run() {
        }
    }
}

