/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.bcb.ui;

import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.LabelUI;
import org.jvnet.flamingo.bcb.BreadcrumbBar;
import org.jvnet.flamingo.bcb.BreadcrumbBarEvent;
import org.jvnet.flamingo.bcb.BreadcrumbItem;
import org.jvnet.flamingo.bcb.BreadcrumbItemChoices;
import org.jvnet.flamingo.bcb.ui.BasicBreadcrumbParticleUI;

public class BreadcrumbParticle
extends JLabel
implements BreadcrumbBar.BreadcrumbBarElement {
    private BreadcrumbItem item = null;
    private ButtonModel model;
    protected BreadcrumbBar bar;
    private static final String uiClassID = "BreadcrumbParticleUI";

    public BreadcrumbParticle(BreadcrumbBar bar, BreadcrumbItem bi, int width) {
        this.bar = bar;
        this.setText(bi.getName());
        this.setIcon(bi.getIcon());
        if (bi.getValue().length > 1) {
            this.setName(bi.getValue()[1]);
        }
        this.setFocusable(true);
        this.item = bi;
        this.setHorizontalAlignment(10);
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.model = new DefaultButtonModel();
        this.model.setSelected(false);
        this.updateUI();
    }

    public int getIndex() {
        return this.item.getIndex();
    }

    public void validateElement() {
        BreadcrumbItem[] oldpath = this.bar.getPath();
        BreadcrumbItem[] path = this.bar.getPath(this.item.getIndex());
        while (this.bar.getStack().size() > this.item.getIndex() + 1) {
            this.bar.pop();
        }
        BreadcrumbItemChoices bic = this.bar.getCallback().getChoices(path);
        if (bic != null) {
            this.bar.pushChoices(bic);
        }
        this.bar.getUI().updateComponents();
        this.bar.fireBreadcrumbBarEvent(new BreadcrumbBarEvent(this.bar, 0, oldpath, this.bar.getPath()));
    }

    public void setUI(LabelUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((LabelUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicBreadcrumbParticleUI());
        }
    }

    public LabelUI getUI() {
        return (LabelUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public BreadcrumbBar getBar() {
        return this.bar;
    }

    public ButtonModel getModel() {
        return this.model;
    }
}

