/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ide;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import org.jvnet.flamingo.ide.ColorDispatcher;
import org.jvnet.flamingo.ide.LocationParser;
import org.jvnet.flamingo.ide.MessageListDialog;
import org.jvnet.flamingo.ide.StringListPanel;
import org.jvnet.flamingo.ide.gutter.AbsoluteGutterPanel;
import org.jvnet.flamingo.ide.gutter.GutterPanel;
import org.jvnet.flamingo.ide.gutter.RelativeGutterPanel;
import org.jvnet.flamingo.ide.info.FileInfo;
import org.jvnet.flamingo.ide.info.FileLocationInfo;
import org.jvnet.flamingo.ide.info.GlobalSettings;
import org.jvnet.flamingo.ide.xml.XmlColorDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BaseViewerPanel
extends JComponent {
    private final AbsoluteGutterPanel absoluteGutter;
    private final RelativeGutterPanel relativeGutter;
    private final StringListPanel textPanel;
    private final JScrollBar horizontalScrollBar;
    private final JScrollBar verticalScrollBar;
    private FileInfo fileInfo;
    private boolean toShowAbsoluteGutter;
    private boolean toShowRelativeGutter;
    private final Logger _logger = Logger.getLogger(BaseViewerPanel.class.getName());

    public BaseViewerPanel(GlobalSettings globalSettings) {
        this.setLayout(new BaseViewerLayout());
        this.textPanel = new StringListPanel(null, globalSettings);
        this.textPanel.addMouseWheelListener(new PanelMouseWheelListener(this));
        this.horizontalScrollBar = new JScrollBar(0);
        this.horizontalScrollBar.addAdjustmentListener(new HorizontalAdjustmentListener(this));
        this.verticalScrollBar = new JScrollBar(1);
        this.verticalScrollBar.addAdjustmentListener(new VerticalAdjustmentListener(this));
        this.absoluteGutter = new AbsoluteGutterPanel(this);
        this.relativeGutter = new RelativeGutterPanel(this, (Integer)UIManager.getLookAndFeelDefaults().get("ScrollBar.width"));
        this.add(this.textPanel);
        this.add(this.horizontalScrollBar);
        this.add(this.verticalScrollBar);
        this.add((Component)this.absoluteGutter, "West");
        this.add((Component)this.relativeGutter, "East");
        this.setBorder(null);
        this.absoluteGutter.setBorder(null);
        this.relativeGutter.setBorder(null);
        this.textPanel.setBorder(null);
        this.verticalScrollBar.setBorder(null);
        this.horizontalScrollBar.setBorder(null);
        this.toShowAbsoluteGutter = true;
        this.toShowRelativeGutter = true;
    }

    public void setToShowAbsoluteGutter(boolean toShowAbsoluteGutter) {
        this.toShowAbsoluteGutter = toShowAbsoluteGutter;
        this.absoluteGutter.setVisible(this.toShowAbsoluteGutter);
    }

    public void setToShowRelativeGutter(boolean toShowRelativeGutter) {
        this.toShowRelativeGutter = toShowRelativeGutter;
        this.relativeGutter.setVisible(this.toShowRelativeGutter);
    }

    public final void wasScrolledVertically() {
        int totalStrings = this.textPanel.getLineCount();
        BoundedRangeModel brm = this.verticalScrollBar.getModel();
        double coefFirst = (double)this.verticalScrollBar.getValue() / (double)brm.getMaximum();
        double firstRow = coefFirst * (double)totalStrings;
        this.textPanel.setFirstVisibleLine(firstRow);
        this.absoluteGutter.refreshView();
    }

    public final void recalibrateScrollBars() {
        int newValue;
        int extent;
        int maxValue;
        if (this.textPanel.isEmpty()) {
            return;
        }
        int strWidth = this.textPanel.getTotalWidthInPixels();
        int strHeight = this.textPanel.getTotalHeightInPixels();
        int editorWidth = this.textPanel.getWidth();
        int editorHeight = this.textPanel.getHeight();
        if (strWidth <= editorWidth) {
            this.horizontalScrollBar.setEnabled(false);
            this.textPanel.setFirstVisibleColumn(0.0);
        } else {
            maxValue = 1000;
            extent = (int)(1000.0 * (double)editorWidth / (double)strWidth);
            double currFirstColumn = this.textPanel.getFirstColumn();
            currFirstColumn = this.textPanel.setFirstVisibleColumn(currFirstColumn);
            newValue = (int)((double)maxValue * currFirstColumn / (double)this.textPanel.getMaximalColumns());
            this.horizontalScrollBar.setValues(newValue, extent, 0, maxValue);
            this.horizontalScrollBar.setEnabled(true);
        }
        if (strHeight <= editorHeight) {
            this.verticalScrollBar.setEnabled(false);
            this.textPanel.setFirstVisibleLine(0.0);
        } else {
            maxValue = 1000;
            extent = (int)(1000.0 * (double)editorHeight / (double)strHeight);
            double currFirstRow = this.textPanel.getTopLine();
            currFirstRow = this.textPanel.setFirstVisibleLine(currFirstRow);
            newValue = (int)((double)maxValue * currFirstRow / (double)this.textPanel.getLineCount());
            this.verticalScrollBar.setValues(newValue, extent, 0, maxValue);
            this.verticalScrollBar.setEnabled(true);
        }
    }

    public final void scrollToLine(int lineNumber) {
        int maxValue = this.verticalScrollBar.getModel().getMaximum();
        double firstRow = (double)lineNumber - this.textPanel.getVisibleLinesCount() / 2.0;
        int newValue = (int)((double)maxValue * firstRow / (double)this.textPanel.getLineCount());
        newValue = Math.max(0, newValue);
        this.verticalScrollBar.setValue(newValue);
        this.textPanel.setFirstVisibleLine(firstRow);
        this.absoluteGutter.repaint();
        this.relativeGutter.repaint();
    }

    public final void setContents(InputStream stream, FileInfo fileInfo, LocationParser locationParser, ColorDispatcher colorDispatcher) {
        this.fileInfo = fileInfo;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedReader br = null;
        try {
            String line;
            LinkedList<String> lines = new LinkedList<String>();
            br = new BufferedReader(new InputStreamReader(stream));
            while ((line = br.readLine()) != null) {
                line = colorDispatcher instanceof XmlColorDispatcher ? line.replaceAll("\t", " ") : line.replaceAll("\t", "   ");
                lines.addLast(line);
                baos.write((line + "\n").getBytes());
            }
            this.textPanel.setLines(lines.toArray(new String[0]));
            this.updateFileInfo(fileInfo);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            FileLocationInfo fei = locationParser.getFileLocationInfo(bais);
            colorDispatcher.setFileLocationInfo(fei);
            this.textPanel.setColorDispatcher(colorDispatcher);
            this.horizontalScrollBar.setValue(0);
            this.verticalScrollBar.setValue(0);
            this.recalibrateScrollBars();
        }
        catch (Exception exc) {
            MessageListDialog.showMessageDialog(null, "Unexpected condition, please file bug report", exc);
            exc.printStackTrace();
            throw new IllegalStateException(exc);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exc) {}
            }
        }
    }

    public final Collection<FileInfo.LineInfo> getMessageList() {
        if (this.fileInfo == null) {
            return null;
        }
        return this.fileInfo.getMessages();
    }

    public final StringListPanel getTextPanel() {
        return this.textPanel;
    }

    @Override
    protected final void paintComponent(Graphics g) {
        g.setColor(GutterPanel.BACKGROUND_COLOR);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paintComponent(g);
    }

    public void updateFileInfo(FileInfo fileInfo) {
        HashMap<Integer, FileInfo.MessageKind> messageLines = new HashMap<Integer, FileInfo.MessageKind>();
        this.fileInfo = fileInfo;
        if (fileInfo != null) {
            for (FileInfo.LineInfo lineInfo : fileInfo.getMessages()) {
                messageLines.put(lineInfo.getLineNumber(), lineInfo.getHighestSeverity());
            }
        }
        this.textPanel.setMessageLines(messageLines);
    }

    public int getLineNumber(int x, int y) {
        return this.textPanel.getLineNumber(x, y);
    }

    public FileInfo.LineInfo getLineMessages(int lineNumber) {
        return this.fileInfo.getMessages(lineNumber - 1);
    }

    public String getContents(int lineNumber) {
        return this.textPanel.getContents(lineNumber);
    }

    public void replaceLine(int lineNumber, String newContents) {
        this.textPanel.replaceLine(lineNumber, newContents);
    }

    private class BaseViewerLayout
    implements LayoutManager {
        private BaseViewerLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            return BaseViewerPanel.this.getSize();
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public void layoutContainer(Container c) {
            Dimension totalDimension = BaseViewerPanel.this.getSize();
            int width = (int)totalDimension.getWidth();
            int height = (int)totalDimension.getHeight();
            Dimension vDim = BaseViewerPanel.this.verticalScrollBar.getPreferredSize();
            Dimension hDim = BaseViewerPanel.this.horizontalScrollBar.getPreferredSize();
            int vWidth = vDim.width;
            int hHeight = hDim.height;
            int absGutterWidth = 12;
            if (BaseViewerPanel.this.textPanel.getGlobalSettings().isToShowLineNumbers()) {
                int lineCount = BaseViewerPanel.this.textPanel.getLineCount();
                int lineCountDigits = new String("" + lineCount).length();
                absGutterWidth += lineCountDigits * BaseViewerPanel.this.textPanel.getPositioningInfo().getSingleCharacterWidth();
            }
            int x = 0;
            if (BaseViewerPanel.this.toShowAbsoluteGutter) {
                BaseViewerPanel.this.absoluteGutter.setBounds(0, 0, absGutterWidth, height - hHeight);
                x += BaseViewerPanel.this.absoluteGutter.getWidth();
            } else {
                absGutterWidth = 0;
            }
            int relativeGutterWidth = BaseViewerPanel.this.toShowRelativeGutter ? 12 : 0;
            BaseViewerPanel.this.textPanel.setBounds(x, 0, width - absGutterWidth - relativeGutterWidth - vWidth, height - hHeight);
            BaseViewerPanel.this.verticalScrollBar.setBounds(x += BaseViewerPanel.this.textPanel.getWidth(), 0, vWidth, height - hHeight + 1);
            BaseViewerPanel.this.relativeGutter.setBounds(x += BaseViewerPanel.this.verticalScrollBar.getWidth(), 0, relativeGutterWidth, height - hHeight);
            BaseViewerPanel.this.horizontalScrollBar.setBounds(absGutterWidth, height - hHeight, BaseViewerPanel.this.textPanel.getWidth(), hHeight);
            BaseViewerPanel.this.recalibrateScrollBars();
        }
    }

    private static final class PanelMouseWheelListener
    implements MouseWheelListener {
        private final BaseViewerPanel viewer;

        public PanelMouseWheelListener(BaseViewerPanel viewer) {
            this.viewer = viewer;
        }

        public final void mouseWheelMoved(MouseWheelEvent e) {
            JScrollBar adj = this.viewer.verticalScrollBar;
            if (e.getScrollType() == 0) {
                int totalScrollAmount = e.getUnitsToScroll() * adj.getUnitIncrement();
                adj.setValue(adj.getValue() + totalScrollAmount);
                this.viewer.wasScrolledVertically();
            }
        }
    }

    private static final class HorizontalAdjustmentListener
    implements AdjustmentListener {
        private final BaseViewerPanel viewer;

        public HorizontalAdjustmentListener(BaseViewerPanel viewer) {
            this.viewer = viewer;
        }

        public final void adjustmentValueChanged(AdjustmentEvent e) {
            int totalColumns = this.viewer.textPanel.getMaximalColumns();
            BoundedRangeModel brm = this.viewer.horizontalScrollBar.getModel();
            double coefFirst = (double)e.getValue() / (double)brm.getMaximum();
            double firstColumn = coefFirst * (double)totalColumns;
            this.viewer.textPanel.setFirstVisibleColumn(firstColumn);
        }
    }

    private static final class VerticalAdjustmentListener
    implements AdjustmentListener {
        private final BaseViewerPanel viewer;

        public VerticalAdjustmentListener(BaseViewerPanel viewer) {
            this.viewer = viewer;
        }

        public final void adjustmentValueChanged(AdjustmentEvent e) {
            this.viewer.wasScrolledVertically();
        }
    }
}

