/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ide.info;

import org.jvnet.flamingo.ide.info.ElementLocation;

public class ElementRange {
    private ElementLocation start;
    private ElementLocation end;

    public ElementRange(int lineStart, int columnStart, int lineEnd, int columnEnd) {
        this.start = new ElementLocation(lineStart, columnStart);
        this.end = new ElementLocation(lineEnd, columnEnd);
    }

    public ElementRange(ElementLocation start, ElementLocation end) {
        this.start = start;
        this.end = end;
    }

    public int getLineStart() {
        return this.start.getLine();
    }

    public int getColumnStart() {
        return this.start.getColumn();
    }

    public int getLineEnd() {
        return this.end.getLine();
    }

    public int getColumnEnd() {
        return this.end.getColumn();
    }

    public ElementLocation getStart() {
        return this.start;
    }

    public ElementLocation getEnd() {
        return this.end;
    }

    public boolean isInside(int lineNumber, int column) {
        boolean isOnEndLine;
        boolean isOnStartLine = lineNumber == this.getLineStart();
        boolean bl = isOnEndLine = lineNumber == this.getLineEnd();
        if (isOnStartLine && isOnEndLine) {
            return column >= this.getColumnStart() && column <= this.getColumnEnd();
        }
        if (isOnStartLine) {
            return column >= this.getColumnStart();
        }
        if (isOnEndLine) {
            return column <= this.getColumnEnd();
        }
        return true;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[");
        result.append(this.getLineStart());
        result.append(":");
        result.append(this.getColumnStart());
        result.append("-");
        if (this.getLineEnd() != this.getLineStart()) {
            result.append(this.getLineEnd());
            result.append(":");
        }
        result.append(this.getColumnEnd());
        result.append("]");
        return result.toString();
    }
}

