/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ide.info;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;

public final class PositioningInfo {
    private int fontSize;
    private int singleCharacterWidth;
    private int singleCharacterHeight;
    private Font baseFont;
    private Font plainFont;
    private Font boldFont;
    private int fontAscent;
    private int fontDescent;

    public final void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public final int getFontSize() {
        return this.fontSize;
    }

    public final void setSingleCharacterWidth(int singleCharacterWidth) {
        this.singleCharacterWidth = singleCharacterWidth;
    }

    public final int getSingleCharacterWidth() {
        return this.singleCharacterWidth;
    }

    public final void setSingleCharacterHeight(int singleCharacterHeight) {
        this.singleCharacterHeight = singleCharacterHeight;
    }

    public final int getSingleCharacterHeight() {
        return this.singleCharacterHeight;
    }

    public final void setBaseFont(Font baseFont) {
        this.baseFont = baseFont;
    }

    public final Font getBaseFont() {
        return this.baseFont;
    }

    public final void setPlainFont(Font plainFont) {
        this.plainFont = plainFont;
    }

    public final Font getPlainFont() {
        return this.plainFont;
    }

    public final void setBoldFont(Font boldFont) {
        this.boldFont = boldFont;
    }

    public final Font getBoldFont() {
        return this.boldFont;
    }

    public final void setFontAscent(int fontAscent) {
        this.fontAscent = fontAscent;
    }

    public final int getFontAscent() {
        return this.fontAscent;
    }

    public final void setFontDescent(int fontDescent) {
        this.fontDescent = fontDescent;
    }

    public final int getFontDescent() {
        return this.fontDescent;
    }

    public static PositioningInfo getPositioningInfo(Font font, int fontSize) {
        int currMaxWidth = 0;
        BufferedImage tempImage = new BufferedImage(fontSize, fontSize, 2);
        Graphics2D graphics = (Graphics2D)tempImage.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        Font regularFont = font.deriveFont(0, fontSize);
        Font boldFont = font.deriveFont(1, fontSize);
        graphics.setFont(boldFont);
        FontRenderContext frc = graphics.getFontRenderContext();
        for (int ind = 32; ind <= 126; ++ind) {
            char c = (char)ind;
            TextLayout mLayout = new TextLayout("" + c, boldFont, frc);
            double currWidth = mLayout.getBounds().getWidth();
            int currWidthTop = (int)Math.ceil(currWidth);
            currMaxWidth = Math.max(currMaxWidth, currWidthTop);
        }
        PositioningInfo result = new PositioningInfo();
        result.setBaseFont(font);
        result.setBoldFont(boldFont);
        result.setPlainFont(regularFont);
        result.setFontSize(fontSize);
        result.setSingleCharacterWidth(currMaxWidth);
        result.setFontAscent((int)Math.ceil(graphics.getFontMetrics().getAscent()));
        result.setFontDescent((int)Math.ceil(graphics.getFontMetrics().getDescent()));
        result.setSingleCharacterHeight(result.getFontAscent() + result.getFontDescent());
        return result;
    }
}

