/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ide.link;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.jvnet.flamingo.ide.link.LinkInfo;

public class LinkRepository {
    private Set<LinkInfo> allLinks;
    private static LinkRepository instance;
    private final Logger _logger = Logger.getLogger(LinkRepository.class.getName());

    private LinkRepository() {
        this.allLinks = new HashSet<LinkInfo>();
    }

    public static synchronized LinkRepository getHandle() {
        if (instance != null) {
            return instance;
        }
        instance = new LinkRepository();
        return instance;
    }

    public void addLinkInfo(LinkInfo linkInfo) {
        this.allLinks.add(linkInfo);
    }

    public LinkInfo getLinkInfo(String token) {
        for (LinkInfo currInfo : this.allLinks) {
            if (token.compareTo(currInfo.getPackageName() + "." + currInfo.getClassName()) != 0) continue;
            return currInfo;
        }
        for (LinkInfo currInfo : this.allLinks) {
            if (token.compareTo(currInfo.getClassName()) != 0) continue;
            return currInfo;
        }
        return null;
    }

    public void dump() {
        for (LinkInfo currInfo : this.allLinks) {
            this._logger.info(currInfo.toString());
        }
    }
}

