/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ribbon;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jvnet.flamingo.ribbon.JRibbonBand;
import org.jvnet.flamingo.ribbon.JToggleTabButton;
import org.jvnet.flamingo.ribbon.RibbonTask;
import org.jvnet.flamingo.ribbon.gallery.JPopupGallery;
import org.jvnet.flamingo.ribbon.ui.BasicRibbonUI;
import org.jvnet.flamingo.ribbon.ui.RibbonUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRibbon
extends JComponent {
    private ArrayList<RibbonTask> tasks = new ArrayList();
    private ArrayList<Component> regularComponents = new ArrayList();
    private ArrayList<JToggleTabButton> taskToggleButtons = new ArrayList();
    private ArrayList<JRibbonBand> bands = new ArrayList();
    private RibbonTask currentlySelectedTask = null;
    private RibbonTask helpTask;
    private ButtonGroup taskToggleButtonGroup = new ButtonGroup();
    private int alignment = 2;
    private Map<RibbonTask, JToggleTabButton> taskButtons = new HashMap<RibbonTask, JToggleTabButton>();
    private static final String uiClassID = "RibbonUI";

    public JRibbon() {
        this.updateUI();
    }

    @Override
    public Component add(Component comp, int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(Component comp, Object constraints) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Component add(Component comp) {
        this.regularComponents.add(comp);
        return super.add(comp);
    }

    private Component addInternal(Component comp) {
        return super.add(comp);
    }

    @Override
    public void remove(Component comp) {
        this.regularComponents.remove(comp);
        super.remove(comp);
    }

    public JToggleButton addTask(String name, final RibbonTask task) {
        if (this.helpTask != null) {
            this.tasks.add(this.tasks.size() - 1, task);
        } else {
            this.tasks.add(task);
        }
        JToggleTabButton taskToggleButton = new JToggleTabButton(name);
        this.taskToggleButtonGroup.add(taskToggleButton);
        this.taskToggleButtons.add(taskToggleButton);
        this.addInternal(taskToggleButton);
        this.taskButtons.put(task, taskToggleButton);
        if (this.tasks.size() == 1) {
            this.setSelectedTask(task);
            taskToggleButton.setSelected(true);
        }
        taskToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JPopupGallery.hidePopups(null);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JRibbon.this.setSelectedTask(task);
                    }
                });
            }
        });
        for (int i = 0; i < task.getBandCount(); ++i) {
            JRibbonBand panel = task.getBand(i);
            this.addInternal(panel);
            if (this.tasks.size() <= 1) continue;
            panel.setVisible(false);
        }
        return taskToggleButton;
    }

    public void removeTask(RibbonTask task) {
        int index = this.tasks.indexOf(task);
        this.removeTask(index);
    }

    public void removeTask(int index) {
        if (index >= 0) {
            RibbonTask toRemove = this.tasks.get(index);
            this.tasks.remove(toRemove);
            if (this.currentlySelectedTask == toRemove) {
                if (--index < 0) {
                    ++index;
                }
                if (index < this.tasks.size()) {
                    this.setSelectedTask(this.tasks.get(index));
                }
            }
            if (this.helpTask == toRemove) {
                this.helpTask = null;
            }
            JToggleTabButton taskToggleButton = this.taskButtons.get(toRemove);
            this.taskToggleButtons.remove(taskToggleButton);
            this.taskToggleButtons.remove(taskToggleButton);
            this.taskToggleButtonGroup.remove(taskToggleButton);
            this.remove(taskToggleButton);
        }
    }

    public int getTaskCount() {
        return this.tasks.size();
    }

    public RibbonTask getTask(int index) {
        return this.tasks.get(index);
    }

    public void setSelectedTask(RibbonTask task) {
        for (JRibbonBand panel : this.bands) {
            panel.setVisible(false);
        }
        this.bands.clear();
        for (int i = 0; i < task.getBandCount(); ++i) {
            JRibbonBand panel;
            panel = task.getBand(i);
            panel.setVisible(true);
            this.bands.add(panel);
        }
        this.currentlySelectedTask = task;
        this.taskButtons.get(task).setSelected(true);
        this.revalidate();
        this.repaint();
    }

    public void setSelectedTask(int taskIndex) {
        int taskCount = this.getTaskCount();
        if (taskIndex < 0 || taskIndex >= taskCount) {
            return;
        }
        this.setSelectedTask(this.tasks.get(taskIndex));
    }

    public int getSelectedTaskIndex() {
        return this.tasks.indexOf(this.currentlySelectedTask);
    }

    public RibbonTask getSelectedTask() {
        return this.currentlySelectedTask;
    }

    public void setUI(RibbonUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((RibbonUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicRibbonUI());
        }
    }

    @Override
    public RibbonUI getUI() {
        return (RibbonUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public ArrayList<Component> getRegularComponents() {
        return this.regularComponents;
    }

    public ArrayList<JRibbonBand> getBands() {
        return this.bands;
    }

    public ArrayList<JToggleTabButton> getTaskToggleButtons() {
        return this.taskToggleButtons;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
        this.doLayout();
        this.repaint();
    }

    public RibbonTask getHelpTask() {
        return this.helpTask;
    }

    public void setHelpTask(RibbonTask helpTask) {
        if (!this.tasks.contains(helpTask)) {
            throw new IllegalArgumentException("No such task in ribbon");
        }
        this.helpTask = helpTask;
        this.tasks.remove(this.helpTask);
        this.tasks.add(this.helpTask);
    }

    public JToggleTabButton getHelpTaskButton() {
        if (this.helpTask == null) {
            return null;
        }
        return this.taskButtons.get(this.helpTask);
    }
}

