/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ribbon.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import org.jvnet.flamingo.common.JButtonStrip;
import org.jvnet.flamingo.ribbon.JRibbonButton;
import org.jvnet.flamingo.ribbon.JRibbonGallery;
import org.jvnet.flamingo.ribbon.gallery.JPopupGallery;
import org.jvnet.flamingo.ribbon.ui.RibbonGalleryUI;

public class BasicRibbonGalleryUI
extends RibbonGalleryUI {
    protected JRibbonGallery ribbonGallery;
    protected int firstButtonIndex;
    protected int lastButtonIndex;
    protected int visibleButtonsCount;
    protected AbstractButton scrollDownButton;
    protected AbstractButton scrollUpButton;
    protected AbstractButton expandActionButton;
    protected JButtonStrip buttonStrip;
    protected ActionListener scrollDownListener;
    protected ActionListener scrollUpListener;
    protected ActionListener expandListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicRibbonGalleryUI();
    }

    public void installUI(JComponent c) {
        this.ribbonGallery = (JRibbonGallery)c;
        this.firstButtonIndex = 0;
        this.visibleButtonsCount = 0;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        c.setLayout(this.createLayoutManager());
    }

    protected void installComponents() {
        this.buttonStrip = new JButtonStripUIResource(JButtonStrip.StripOrientation.VERTICAL);
        this.ribbonGallery.add(this.buttonStrip);
        this.scrollUpButton = this.createScrollUpButton();
        this.scrollDownButton = this.createScrollDownButton();
        this.expandActionButton = this.createExpandButton();
        this.buttonStrip.add(this.scrollUpButton);
        this.buttonStrip.add(this.scrollDownButton);
        this.buttonStrip.add(this.expandActionButton);
    }

    protected AbstractButton createScrollDownButton() {
        return new BasicArrowButton(5);
    }

    protected AbstractButton createScrollUpButton() {
        return new BasicArrowButton(1);
    }

    protected AbstractButton createExpandButton() {
        return new BasicArrowButton(5);
    }

    protected void uninstallComponents() {
        this.buttonStrip.remove(this.scrollUpButton);
        this.buttonStrip.remove(this.scrollDownButton);
        this.buttonStrip.remove(this.expandActionButton);
        this.ribbonGallery.remove(this.buttonStrip);
    }

    protected void installDefaults() {
        this.ribbonGallery.setBorder(new EmptyBorder(3, 3, 3, 3));
    }

    protected void uninstallDefaults() {
    }

    protected void installListeners() {
        this.scrollDownListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasicRibbonGalleryUI.this.firstButtonIndex += BasicRibbonGalleryUI.this.visibleButtonsCount;
                if (BasicRibbonGalleryUI.this.visibleButtonsCount > 1) {
                    --BasicRibbonGalleryUI.this.firstButtonIndex;
                }
                if (BasicRibbonGalleryUI.this.firstButtonIndex >= BasicRibbonGalleryUI.this.ribbonGallery.getButtonCount()) {
                    BasicRibbonGalleryUI.this.firstButtonIndex = BasicRibbonGalleryUI.this.ribbonGallery.getButtonCount() - 1;
                }
                BasicRibbonGalleryUI.this.ribbonGallery.revalidate();
            }
        };
        this.scrollDownButton.addActionListener(this.scrollDownListener);
        this.scrollUpListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasicRibbonGalleryUI.this.lastButtonIndex = BasicRibbonGalleryUI.this.firstButtonIndex + 1;
                BasicRibbonGalleryUI.this.firstButtonIndex = -1;
                if (BasicRibbonGalleryUI.this.visibleButtonsCount == 1) {
                    --BasicRibbonGalleryUI.this.lastButtonIndex;
                }
                BasicRibbonGalleryUI.this.ribbonGallery.revalidate();
            }
        };
        this.scrollUpButton.addActionListener(this.scrollUpListener);
        this.expandListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JPopupGallery.hidePopups(BasicRibbonGalleryUI.this.ribbonGallery);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        int ph;
                        PopupFactory popupFactory = PopupFactory.getSharedInstance();
                        JPopupGallery ribbonPopupGallery = BasicRibbonGalleryUI.this.ribbonGallery.getPopupGallery();
                        if (ribbonPopupGallery == null) {
                            return;
                        }
                        int x = BasicRibbonGalleryUI.this.ribbonGallery.getLocationOnScreen().x;
                        int y = BasicRibbonGalleryUI.this.ribbonGallery.getLocationOnScreen().y;
                        Rectangle scrBounds = BasicRibbonGalleryUI.this.ribbonGallery.getGraphicsConfiguration().getBounds();
                        int pw = ribbonPopupGallery.getPreferredSize().width;
                        if (x + pw > scrBounds.x + scrBounds.width) {
                            x = scrBounds.x + scrBounds.width - pw;
                        }
                        if (y + (ph = ribbonPopupGallery.getPreferredSize().height) > scrBounds.y + scrBounds.height) {
                            y = scrBounds.y + scrBounds.height - ph;
                        }
                        Popup popup = popupFactory.getPopup(BasicRibbonGalleryUI.this.ribbonGallery, ribbonPopupGallery, x, y);
                        popup.show();
                        BasicRibbonGalleryUI.this.ribbonGallery.repaint();
                        JPopupGallery.addPopup(popup, ribbonPopupGallery);
                    }
                });
            }
        };
        this.expandActionButton.addActionListener(this.expandListener);
    }

    protected void uninstallListeners() {
        this.scrollDownButton.removeActionListener(this.scrollDownListener);
        this.scrollDownListener = null;
        this.scrollUpButton.removeActionListener(this.scrollUpListener);
        this.scrollUpListener = null;
        this.expandActionButton.removeActionListener(this.expandListener);
        this.expandListener = null;
    }

    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.ribbonGallery = null;
    }

    protected LayoutManager createLayoutManager() {
        return new RibbonGalleryLayout();
    }

    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.paintRibbonGalleryBackground(graphics, new Rectangle(0, 0, c.getWidth(), c.getHeight()));
        graphics.dispose();
    }

    protected void paintRibbonGalleryBackground(Graphics graphics, Rectangle toFill) {
        graphics.setColor(this.ribbonGallery.getBackground());
        graphics.fillRect(toFill.x, toFill.y, toFill.width, toFill.height);
    }

    private class RibbonGalleryLayout
    implements LayoutManager {
        private RibbonGalleryLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            return new Dimension(BasicRibbonGalleryUI.this.ribbonGallery.getPreferredWidth(BasicRibbonGalleryUI.this.ribbonGallery.getState()), c.getHeight());
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public void layoutContainer(Container c) {
            int currButtonWidth;
            JRibbonButton currButton;
            int width = c.getWidth();
            int height = c.getHeight();
            Insets borderInsets = BasicRibbonGalleryUI.this.ribbonGallery.getBorder().getBorderInsets(BasicRibbonGalleryUI.this.ribbonGallery);
            int totalButtonHeight = (int)(0.9 * (double)height);
            int buttonY = (height - totalButtonHeight) / 2;
            int buttonHeight = totalButtonHeight / 3;
            int buttonWidth = 15;
            int buttonX = width - buttonWidth - borderInsets.right;
            BasicRibbonGalleryUI.this.scrollDownButton.setPreferredSize(new Dimension(buttonWidth, buttonHeight));
            BasicRibbonGalleryUI.this.scrollUpButton.setPreferredSize(new Dimension(buttonWidth, buttonHeight));
            BasicRibbonGalleryUI.this.expandActionButton.setPreferredSize(new Dimension(buttonWidth, totalButtonHeight - 2 * buttonHeight));
            BasicRibbonGalleryUI.this.buttonStrip.setBounds(buttonX, buttonY, buttonWidth, totalButtonHeight);
            for (int i = 0; i < BasicRibbonGalleryUI.this.ribbonGallery.getButtonCount(); ++i) {
                JRibbonButton currButton2 = BasicRibbonGalleryUI.this.ribbonGallery.getButtonAt(i);
                currButton2.setVisible(false);
            }
            int currIndex = BasicRibbonGalleryUI.this.firstButtonIndex;
            int startX = borderInsets.left;
            if (currIndex < 0) {
                startX = buttonX;
                for (currIndex = BasicRibbonGalleryUI.this.lastButtonIndex; currIndex >= 0; --currIndex) {
                    BasicRibbonGalleryUI.this.firstButtonIndex = currIndex;
                    currButton = BasicRibbonGalleryUI.this.ribbonGallery.getButtonAt(currIndex);
                    currButtonWidth = currButton.getPreferredSize().width;
                    int currStartX = startX - currButtonWidth - 4;
                    if (currStartX < 0) break;
                    startX = currStartX;
                }
            }
            BasicRibbonGalleryUI.this.visibleButtonsCount = 0;
            startX = borderInsets.left;
            for (currIndex = BasicRibbonGalleryUI.this.firstButtonIndex; currIndex < BasicRibbonGalleryUI.this.ribbonGallery.getButtonCount(); ++currIndex) {
                currButton = BasicRibbonGalleryUI.this.ribbonGallery.getButtonAt(currIndex);
                currButtonWidth = currButton.getPreferredSize().width;
                int currButtonHeight = currButton.getPreferredSize().height;
                int nextStartX = startX + currButtonWidth + 4;
                if (nextStartX >= buttonX) break;
                int topY = (height - currButtonHeight) / 2;
                currButton.setVisible(true);
                currButton.setBounds(startX, topY, currButtonWidth, currButtonHeight);
                startX = nextStartX;
                ++BasicRibbonGalleryUI.this.visibleButtonsCount;
            }
            BasicRibbonGalleryUI.this.scrollDownButton.setEnabled(currIndex < BasicRibbonGalleryUI.this.ribbonGallery.getButtonCount());
            BasicRibbonGalleryUI.this.scrollUpButton.setEnabled(BasicRibbonGalleryUI.this.firstButtonIndex > 0);
        }
    }

    protected static class JButtonStripUIResource
    extends JButtonStrip
    implements UIResource {
        public JButtonStripUIResource() {
        }

        public JButtonStripUIResource(JButtonStrip.StripOrientation orientation) {
            super(orientation);
        }
    }
}

