/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.slider;

import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jvnet.flamingo.slider.DefaultFlexiRangeModel;
import org.jvnet.flamingo.slider.FlexiRangeModel;
import org.jvnet.flamingo.slider.ui.BasicFlexiSliderUI;
import org.jvnet.flamingo.slider.ui.FlexiSliderUI;

public class JFlexiSlider
extends JComponent {
    private static final String uiClassID = "FlexiSliderUI";
    protected FlexiRangeModel model;
    private Icon[] controlPointIcons;
    private String[] controlPointTexts;

    public void setUI(FlexiSliderUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((FlexiSliderUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicFlexiSliderUI());
        }
    }

    public FlexiSliderUI getUI() {
        return (FlexiSliderUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public JFlexiSlider(FlexiRangeModel.Range[] ranges, Icon[] controlPointIcons, String[] controlPointTexts) throws NullPointerException, IllegalArgumentException {
        int i;
        if (ranges == null || controlPointIcons == null || controlPointTexts == null) {
            throw new NullPointerException("Parameters should be non-null");
        }
        int rangeCount = ranges.length;
        if (rangeCount != controlPointIcons.length - 1 || rangeCount != controlPointTexts.length - 1) {
            throw new IllegalArgumentException("Parameter sizes don't match");
        }
        this.model = new DefaultFlexiRangeModel();
        this.model.setRanges(ranges);
        this.controlPointIcons = new Icon[controlPointIcons.length];
        for (i = 0; i < controlPointIcons.length; ++i) {
            this.controlPointIcons[i] = controlPointIcons[i];
        }
        this.controlPointTexts = new String[controlPointTexts.length];
        for (i = 0; i < controlPointTexts.length; ++i) {
            this.controlPointTexts[i] = controlPointTexts[i];
        }
        this.updateUI();
    }

    public int getControlPointCount() {
        return this.model.getRangeCount() + 1;
    }

    public Icon getControlPointIcon(int controlPointIndex) {
        return this.controlPointIcons[controlPointIndex];
    }

    public String getControlPointText(int controlPointIndex) {
        return this.controlPointTexts[controlPointIndex];
    }

    public FlexiRangeModel getModel() {
        return this.model;
    }

    public FlexiRangeModel.Value getValue() {
        return this.model.getValue();
    }

    public void setValue(FlexiRangeModel.Value value) {
        FlexiRangeModel m = this.getModel();
        FlexiRangeModel.Value oldValue = m.getValue();
        if (value.equals(oldValue)) {
            return;
        }
        m.setValue(value);
    }
}

