/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.mirror;

import ddb.dsz.annotations.DszDescription;
import ddb.dsz.annotations.DszLive;
import ddb.dsz.annotations.DszLogo;
import ddb.dsz.annotations.DszName;
import ddb.dsz.plugin.mirror.Mirror;
import ddb.dsz.plugin.mirror.MonitorThread;
import ddb.dsz.plugin.mirror.jaxb.mirrorcomms.MirrorFileStatus;
import ddb.dsz.plugin.mirror.jaxb.mirrorcomms.MirrorNext;
import ddb.dsz.plugin.mirror.jaxb.mirrorcomms.MirrorRequest;
import ddb.dsz.plugin.peer.PeerTag;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;

@DszLive(live=true, replay=false)
@DszLogo(value="images/config-users.png")
@DszName(value="Reflection")
@DszDescription(value="Enables a connected Peer to have a mirror of the log files")
public class LiveMirror
extends Mirror {
    Object transferLock = new Object();
    Map<Object, MonitorThread> tagToMonitor = new HashMap<Object, MonitorThread>();

    public void newConnection(PeerTag peerTag) {
    }

    public void receivedMessage(String string, PeerTag peerTag) {
        super.receivedMessage(string, peerTag);
        try {
            Object object;
            Object object2 = super.unmarshal(string);
            if (object2 instanceof JAXBElement) {
                object2 = ((JAXBElement)JAXBElement.class.cast(object2)).getValue();
            }
            if (object2 instanceof MirrorRequest) {
                object = this.tagToMonitor.get(peerTag);
                if (object == null) {
                    object = new MonitorThread(this.core, this.model, peerTag);
                    this.tagToMonitor.put(peerTag, (MonitorThread)object);
                }
                this.core.newThread((Runnable)object).start();
            }
            if (object2 instanceof MirrorFileStatus) {
                object = (MirrorFileStatus)object2;
                MonitorThread monitorThread = this.tagToMonitor.get(peerTag);
                if (monitorThread == null) {
                    monitorThread = new MonitorThread(this.core, this.model, peerTag);
                    this.tagToMonitor.put(peerTag, monitorThread);
                }
                monitorThread.addFile(((MirrorFileStatus)object).getFile(), ((MirrorFileStatus)object).getLength());
            }
            if (object2 instanceof MirrorNext) {
                this.tagToMonitor.get(peerTag).resume();
            }
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
    }
}

