/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.monitor;

import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.task.Task;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.tree.DefaultMutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckNode
extends DefaultMutableTreeNode {
    protected boolean isChangable;
    protected boolean isSelected;
    protected SelectionMode selectionMode = SelectionMode.SingleSelection;
    protected SelectionType selectionType = SelectionType.Always;

    public CheckNode() {
        this(null);
    }

    public CheckNode(Object object) {
        this(object, true, true);
    }

    public CheckNode(Object object, boolean bl, boolean bl2) {
        super(object, bl2);
        this.isSelected = bl;
        this.isChangable = true;
        this.setSelectionMode(SelectionMode.SingleSelection);
    }

    public boolean isSelected() {
        Object object = this.getUserObject();
        if (object instanceof Task || object instanceof HostInfo) {
            return this.isSelected && ((CheckNode)CheckNode.class.cast(this.parent)).isSelected();
        }
        return this.isSelected;
    }

    public boolean isChangable() {
        return this.isChangable;
    }

    public void setSelectionMode(SelectionMode selectionMode) {
        this.selectionMode = selectionMode;
    }

    public void setSelectionType(SelectionType selectionType) {
        this.selectionType = selectionType;
    }

    public SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    public void setChangable(boolean bl) {
        this.isChangable = bl;
    }

    public Collection<CheckNode> setSelected(boolean bl) {
        HashSet<CheckNode> hashSet = new HashSet<CheckNode>();
        if (!this.isChangable) {
            return hashSet;
        }
        this.isSelected = bl;
        switch (this.selectionType) {
            case OnFalse: {
                if (!bl) break;
                return hashSet;
            }
            case OnTrue: {
                if (bl) break;
                return hashSet;
            }
        }
        switch (this.selectionMode) {
            case DigInSelection: {
                if (this.children == null) break;
                Enumeration enumeration = this.children.elements();
                while (enumeration.hasMoreElements()) {
                    CheckNode checkNode = (CheckNode)enumeration.nextElement();
                    hashSet.addAll(checkNode.setSelected(bl));
                }
                break;
            }
            case DigOutSelection: {
                if (this.parent == null || !(this.parent instanceof CheckNode)) break;
                hashSet.addAll(((CheckNode)CheckNode.class.cast(this.parent)).setSelected(bl));
            }
        }
        hashSet.addAll(this.enumerateChildren());
        return hashSet;
    }

    @Override
    public void setUserObject(Object object) {
        if (object instanceof Boolean) {
            this.setSelected((Boolean)Boolean.class.cast(object));
        } else {
            super.setUserObject(object);
        }
    }

    private Collection<CheckNode> enumerateChildren() {
        HashSet<CheckNode> hashSet = new HashSet<CheckNode>();
        if (this.children != null) {
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                CheckNode checkNode = (CheckNode)enumeration.nextElement();
                hashSet.addAll(checkNode.enumerateChildren());
            }
        }
        hashSet.add(this);
        return hashSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SelectionType {
        Always,
        OnTrue,
        OnFalse;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SelectionMode {
        SingleSelection,
        DigInSelection,
        DigOutSelection;

    }
}

