/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.monitor;

import ddb.console.OptionPane;
import ddb.dsz.annotations.DszDescription;
import ddb.dsz.annotations.DszLive;
import ddb.dsz.annotations.DszLogo;
import ddb.dsz.annotations.DszName;
import ddb.dsz.annotations.DszUserStartable;
import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.data.ClosureFactory;
import ddb.dsz.core.data.DataTransformer;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.task.Task;
import ddb.dsz.library.console.ConsoleOutputPane;
import ddb.dsz.plugin.monitor.CheckNode;
import ddb.dsz.plugin.monitor.CheckRenderer;
import ddb.dsz.plugin.monitor.MonitorWindow2;
import ddb.dsz.plugin.monitor.MonitoredCommandOutput;
import ddb.dsz.plugin.monitor.NodeSelectionListener;
import ddb.dsz.plugin.monitor.OutputTableColumns;
import ddb.dsz.plugin.monitor.OutputTableModel;
import ddb.dsz.plugin.multitarget.MultipleTargetPlugin;
import ddb.dsz.plugin.multitarget.SingleTargetImpl;
import ddb.events.AutoScroll;
import ddb.gui.swing.DszTableCellRenderer;
import ddb.util.tablefilter.FilteredTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DszLive(live=true, replay=false)
@DszLogo(value="images/monitor.png")
@DszName(value="Monitor")
@DszDescription(value="Monitored Command Output")
@DszUserStartable(value=false)
public class MonitorHost
extends SingleTargetImpl {
    OutputTableModel outputTableModel;
    JTable outputTable;
    JSplitPane splitPane;
    JPanel mainPanel;
    JFrame outputPopupWindow;
    ConsoleOutputPane detailedOutputArea;
    JScrollPane outputScrollPane;
    DataTransformer transformer = DataTransformer.newInstance();
    JCheckBox bAutoScroll = new JCheckBox("AutoScroll", true);
    Predicate isMonitoredTask = new Predicate(){

        public boolean evaluate(Object object) {
            if (!(object instanceof Task)) {
                return false;
            }
            Task task = (Task)Task.class.cast(object);
            return task.getGuiFlagValue("monitor") != null;
        }
    };
    Predicate shouldShowCommandOutput = new Predicate(){

        public boolean evaluate(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof Task)) {
                return false;
            }
            Task task = (Task)object;
            if (task == null) {
                return false;
            }
            CheckNode checkNode = MonitorHost.this.taskLookup.get(task);
            if (checkNode == null) {
                return false;
            }
            return checkNode.isSelected();
        }
    };
    FilteredTableModel filteredOutput;
    AutoScroll auto;
    JTree tree;
    CheckNode live = new CheckNode("Live Tasks");
    CheckNode complete = new CheckNode("Completed Tasks");
    final Map<Task, CheckNode> taskLookup = Collections.synchronizedMap(new HashMap());
    DefaultTreeModel model;
    MultipleTargetPlugin parent;
    public static final String MONITOR_ICON = "images/monitor.png";
    public static final int MAXIMUM_DEFAULT = 10000;

    public MonitorHost(HostInfo hostInfo, CoreController coreController, MultipleTargetPlugin multipleTargetPlugin) {
        super(hostInfo, coreController);
        this.parent = multipleTargetPlugin;
        int n = 10000;
        Object object = coreController.getOption(MonitorWindow2.class, "-MonitorMaximumLines");
        if (object instanceof Integer) {
            n = (Integer)object;
        } else if (object instanceof String) {
            try {
                n = Integer.parseInt((String)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        coreController.logEvent(Level.FINER, "Monitor:  init");
        this.complete.setSelected(false);
        this.tree = new JTree(new CheckNode[0]);
        this.model = (DefaultTreeModel)this.tree.getModel();
        MutableTreeNode mutableTreeNode = (MutableTreeNode)this.tree.getModel().getRoot();
        this.model.insertNodeInto(this.live, mutableTreeNode, 0);
        this.model.insertNodeInto(this.complete, mutableTreeNode, 1);
        this.tree.expandPath(new TreePath(this.model.getPathToRoot(mutableTreeNode)));
        this.tree.setCellRenderer(new CheckRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.addMouseListener(new NodeSelectionListener(this.tree));
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                CheckNode checkNode;
                int n;
                if (mouseEvent.isPopupTrigger() || mouseEvent.getButton() != 1) {
                    return;
                }
                if (!mouseEvent.isShiftDown()) {
                    return;
                }
                int n2 = mouseEvent.getX();
                int n3 = MonitorHost.this.tree.getRowForLocation(n2, n = mouseEvent.getY());
                TreePath treePath = MonitorHost.this.tree.getPathForRow(n3);
                if (treePath != null && (checkNode = (CheckNode)treePath.getLastPathComponent()).getUserObject() instanceof Task) {
                    MonitorHost.this.showCommand((Task)checkNode.getUserObject());
                }
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.maybePopup(mouseEvent);
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.maybePopup(mouseEvent);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.maybePopup(mouseEvent);
                }
            }

            private void maybePopup(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                int n3 = MonitorHost.this.tree.getRowForLocation(n, n2);
                JPopupMenu jPopupMenu = null;
                TreePath treePath = MonitorHost.this.tree.getPathForRow(n3);
                if (treePath != null) {
                    CheckNode checkNode = (CheckNode)treePath.getLastPathComponent();
                    if (checkNode.getUserObject() instanceof Task) {
                        jPopupMenu = MonitorHost.this.getPopupMenu((Task)checkNode.getUserObject(), checkNode.isSelected());
                    } else if (checkNode.getUserObject() instanceof HostInfo) {
                        jPopupMenu = MonitorHost.this.getPopupMenu((HostInfo)checkNode.getUserObject(), checkNode.isSelected());
                    }
                }
                if (jPopupMenu != null) {
                    jPopupMenu.show(MonitorHost.this.tree, n, n2);
                }
            }
        });
        this.tree.getModel().addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                MonitorHost.this.filteredOutput.filterChanged();
            }

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                MonitorHost.this.filteredOutput.filterChanged();
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                MonitorHost.this.filteredOutput.filterChanged();
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                MonitorHost.this.filteredOutput.filterChanged();
            }
        });
        this.outputTableModel = new OutputTableModel(n);
        this.filteredOutput = new FilteredTableModel((TableModel)((Object)this.outputTableModel));
        this.outputTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getType() == 1) {
                    MonitorHost.this.changeSupport.firePropertyChange("TABBABLE_CONTENT_CHANGED", false, true);
                }
            }
        });
        this.filteredOutput.addFilter(this.shouldShowCommandOutput, new int[]{0});
        this.outputTable = new JTable((TableModel)this.filteredOutput);
        this.outputTable.setDefaultRenderer(Task.class, (TableCellRenderer)new DszTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (!(component instanceof JLabel) || !(object instanceof Task)) {
                    return component;
                }
                JLabel jLabel = (JLabel)component;
                Task task = (Task)object;
                jLabel.setText(task.getCommandName());
                return component;
            }
        });
        this.outputTable.setDefaultRenderer(Long.class, (TableCellRenderer)new DszTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (!(component instanceof JLabel) || !(object instanceof Long)) {
                    return component;
                }
                JLabel jLabel = (JLabel)component;
                jLabel.setHorizontalAlignment(4);
                Long l = (Long)object;
                String string = "";
                if (l < 1000L) {
                    string = String.format("0s.%03d", l);
                } else {
                    string = String.format(".%03d", l % 1000L);
                    if ((l = Long.valueOf(l / 1000L)) < 60L) {
                        string = String.format("%ds%s", l, string);
                    } else {
                        string = String.format("%02ds%s", l % 60L, string);
                        if ((l = Long.valueOf(l / 60L)) < 60L) {
                            string = String.format("%dm%s", l, string);
                        } else {
                            string = String.format("%02dm%s", l % 60L, string);
                            l = l / 60L;
                            string = String.format("%dh%s", l, string);
                        }
                    }
                }
                jLabel.setText(string);
                return component;
            }
        });
        this.outputTable.setDefaultRenderer(String.class, (TableCellRenderer)new DszTableCellRenderer(){
            static final int MAX_OUTPUT_LENGTH = 100;
            static final String ELIPSE = "...";

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (!(component instanceof JLabel) || !(object instanceof Task)) {
                    return component;
                }
                JLabel jLabel = (JLabel)component;
                String string = (String)object;
                if (string.length() > 100) {
                    string = String.format("%s %s", string.substring(0, 100 - (ELIPSE.length() + 1)), ELIPSE);
                }
                jLabel.setText(string);
                return component;
            }
        });
        this.setColumnWidth(OutputTableColumns.COMMAND, "wwwwwwwwwwwwww", true);
        this.setColumnWidth(OutputTableColumns.WHEN, "9h99m99s.999", true);
        this.outputScrollPane = new JScrollPane(this.outputTable);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.outputScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, "South");
        jPanel2.setAlignmentY(0.0f);
        jPanel2.add(this.bAutoScroll);
        this.splitPane = new JSplitPane(1, true, new JScrollPane(this.tree), jPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                MonitorHost.this.splitPane.removeComponentListener(this);
                MonitorHost.this.splitPane.setDividerLocation(0.2);
            }
        });
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add(this.splitPane);
        super.setDisplay((JComponent)this.mainPanel);
        this.setupOutputPopup();
        this.outputTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                MonitorHost.this.outputDoubleClickAction(mouseEvent);
            }
        });
        this.auto = new AutoScroll(this.outputScrollPane);
        this.bAutoScroll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MonitorHost.this.auto.setScroll(MonitorHost.this.bAutoScroll.isSelected());
            }
        });
    }

    private JPopupMenu getPopupMenu(final Task task, boolean bl) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Show All");
        JMenuItem jMenuItem2 = new JMenuItem("Hide All");
        JMenuItem jMenuItem3 = new JMenuItem("Show Only This Task");
        JMenuItem jMenuItem4 = new JMenuItem("Hide This Task");
        JMenuItem jMenuItem5 = new JMenuItem("View Task Output");
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenuItem3);
        jPopupMenu.add(jMenuItem4);
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenuItem5);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MonitorHost.this.complete.setSelected(true);
                MonitorHost.this.live.setSelected(true);
                MonitorHost.this.setHashSettings(MonitorHost.this.taskLookup, true);
                MonitorHost.this.redrawTree();
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MonitorHost.this.setHashSettings(MonitorHost.this.taskLookup, false);
                MonitorHost.this.complete.setSelected(true);
                MonitorHost.this.live.setSelected(true);
                MonitorHost.this.redrawTree();
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MonitorHost.this.setHashSettings(MonitorHost.this.taskLookup, false);
                MonitorHost.this.complete.setSelected(true);
                MonitorHost.this.live.setSelected(true);
                MonitorHost.this.taskLookup.get(task).setSelected(true);
                MonitorHost.this.redrawTree();
            }
        });
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MonitorHost.this.taskLookup.get(task).setSelected(false);
                MonitorHost.this.redrawTree();
            }
        });
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MonitorHost.this.showCommand(task);
            }
        });
        return jPopupMenu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHashSettings(Map<?, CheckNode> map, boolean bl) {
        Map<?, CheckNode> map2 = map;
        synchronized (map2) {
            for (CheckNode checkNode : map.values()) {
                checkNode.setSelected(bl);
            }
        }
    }

    private JPopupMenu getPopupMenu(HostInfo hostInfo, boolean bl) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Show All");
        JMenuItem jMenuItem2 = new JMenuItem("Hide All");
        JMenuItem jMenuItem3 = new JMenuItem("Show Only This Host");
        JMenuItem jMenuItem4 = new JMenuItem("Hide This Host");
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenuItem3);
        jPopupMenu.add(jMenuItem4);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MonitorHost.this.complete.setSelected(true);
                MonitorHost.this.live.setSelected(true);
                MonitorHost.this.redrawTree();
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MonitorHost.this.complete.setSelected(true);
                MonitorHost.this.live.setSelected(true);
                MonitorHost.this.redrawTree();
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MonitorHost.this.complete.setSelected(true);
                MonitorHost.this.live.setSelected(true);
                MonitorHost.this.redrawTree();
            }
        });
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MonitorHost.this.redrawTree();
            }
        });
        return jPopupMenu;
    }

    private void redrawTree() {
        this.tree.revalidate();
        this.tree.repaint();
        this.filteredOutput.filterChanged();
    }

    private void setupOutputPopup() {
        this.core.logEvent(Level.FINER, "Monitor:  SetupOutputPopup()");
        this.outputPopupWindow = new JFrame("Monitored Command Output");
        this.outputPopupWindow.setSize(800, 250);
        this.outputPopupWindow.setDefaultCloseOperation(1);
        this.detailedOutputArea = new ConsoleOutputPane(this.core, Integer.MAX_VALUE);
        this.detailedOutputArea.setTheme(OptionPane.getInstance().getSharedTheme());
        this.outputPopupWindow.getContentPane().add((Component)this.detailedOutputArea);
    }

    public void commandEventReceived(CommandEvent commandEvent) {
        Task task = this.core.getTaskById(commandEvent.getId());
        this.addTask(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(final Task task) {
        if (!this.isMonitoredTask.evaluate((Object)task) || task == null || task.getHost() == null) {
            return;
        }
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    MonitorHost.this.addTask(task);
                }
            });
        } else {
            boolean bl = false;
            CheckNode checkNode = null;
            Map<Task, CheckNode> map = this.taskLookup;
            synchronized (map) {
                checkNode = this.taskLookup.get(task);
                if (checkNode == null) {
                    bl = true;
                    checkNode = new CheckNode(task);
                    checkNode.setSelectionMode(CheckNode.SelectionMode.DigOutSelection);
                    checkNode.setSelectionType(CheckNode.SelectionType.OnTrue);
                    this.taskLookup.put(task, checkNode);
                    this.addTask(this.live, checkNode);
                }
            }
            switch (task.getState()) {
                case FAILED: 
                case KILLED: 
                case SUCCEEDED: {
                    this.removeTask(this.live, checkNode);
                    this.addTask(this.complete, checkNode);
                    break;
                }
            }
            if (!bl) {
                return;
            }
            if (this.transformer != null) {
                this.transformer.addClosure(ClosureFactory.newDisplayClosure((CoreController)this.core, (Task)task, (Closure)new Closure(){

                    public void execute(Object object) {
                        MonitorHost.this.updateDisplay(task, object.toString(), Calendar.getInstance());
                    }
                }));
                this.transformer.addTask(task);
            }
        }
    }

    private void expand(CheckNode checkNode) {
        if (checkNode.getChildCount() != 1) {
            return;
        }
        Object[] objectArray = checkNode.getPath();
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        TreePath treePath = new TreePath(objectArray);
        if (treePath == null) {
            return;
        }
        this.tree.expandPath(treePath);
    }

    private void addTask(CheckNode checkNode, CheckNode checkNode2) {
        this.model.insertNodeInto(checkNode2, checkNode, checkNode.getChildCount());
        this.expand(checkNode);
    }

    private void removeTask(CheckNode checkNode, CheckNode checkNode2) {
        this.model.removeNodeFromParent(checkNode2);
    }

    void updateDisplay(Task task, String string, Calendar calendar) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                MonitorHost.super.fireContentsChanged();
            }
        });
        if (string == null || string.length() == 0) {
            return;
        }
        EventQueue.invokeLater(new MonitorUpdate(task, string, calendar));
    }

    void outputDoubleClickAction(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() < 2) {
            return;
        }
        Task task = (Task)this.outputTable.getValueAt(this.outputTable.getSelectedRow(), OutputTableColumns.COMMAND.ordinal());
        this.showCommand(task);
    }

    void showCommand(Task task) {
        if (task == null) {
            return;
        }
        List<MonitoredCommandOutput> list = this.outputTableModel.getOutputsFor(task);
        StringBuilder stringBuilder = new StringBuilder();
        for (MonitoredCommandOutput monitoredCommandOutput : list) {
            stringBuilder.append(String.format("%s\n", monitoredCommandOutput.getCommandOutput()));
        }
        this.detailedOutputArea.clearAndReplace(stringBuilder.toString());
        if (!this.outputPopupWindow.isVisible()) {
            this.outputPopupWindow.setVisible(true);
        }
    }

    private void setColumnWidth(Enum<?> enum_, String string, boolean bl) {
        TableColumn tableColumn = this.outputTable.getColumnModel().getColumn(enum_.ordinal());
        JLabel jLabel = new JLabel(string);
        tableColumn.setPreferredWidth(jLabel.getPreferredSize().width + 10);
        if (bl) {
            tableColumn.setMaxWidth(jLabel.getPreferredSize().width + 15);
            tableColumn.setMinWidth(jLabel.getPreferredSize().width + 5);
        }
    }

    private class MonitorUpdate
    implements Runnable {
        Task task;
        String[] lines;
        Calendar cal;

        public MonitorUpdate(Task task, String string, Calendar calendar) {
            this.task = task;
            this.lines = string.split("\\n");
            this.cal = calendar;
        }

        public void run() {
            long l = Calendar.getInstance().getTimeInMillis() - this.task.getCreationTime();
            for (String string : this.lines) {
                MonitoredCommandOutput monitoredCommandOutput = new MonitoredCommandOutput(this.task, l, string);
                MonitorHost.this.outputTableModel.addRecord(monitoredCommandOutput);
            }
        }
    }
}

