/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.about;

import ddb.dsz.annotations.DszDescription;
import ddb.dsz.annotations.DszLive;
import ddb.dsz.annotations.DszLogo;
import ddb.dsz.annotations.DszName;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.plugin.NoHostAbstractPlugin;
import ddb.dsz.plugin.Plugin;
import ddb.dsz.plugin.about.jaxb.version.ObjectFactory;
import ddb.dsz.plugin.about.jaxb.version.VersionType;
import ddb.imagemanager.ImageManager;
import ddb.util.AbstractEnumeratedTableModel;
import ddb.util.JaxbCache;
import java.awt.Dimension;
import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

@DszLive(live=true, replay=false)
@DszLogo(value="images/cardgame.png")
@DszName(value="About")
@DszDescription(value="About Danderspritz")
public class About
extends NoHostAbstractPlugin
implements Plugin {
    public static final String ABOUT_ICON = "images/package_games_card.png";
    public static final String[] VERSION_DIRS = new String[]{"Version", "."};
    public static final String FILLED = "images/apply.png";
    public static final String UNFILLED = "images/gg_ignored.png";
    JTable table;
    VersionTableModel model;
    Icon requirementsFilled;
    Icon requirementsUnfilled;

    public About() {
        super.setName("About");
        super.setCareAboutLocalEvents(true);
    }

    protected int init2() {
        this.model = new VersionTableModel();
        this.table = new JTable(this.model);
        super.setDisplay((JComponent)new JScrollPane(this.table));
        this.requirementsFilled = ImageManager.getIcon((String)FILLED, (Dimension)this.core.getLabelImageSize());
        this.requirementsUnfilled = ImageManager.getIcon((String)UNFILLED, (Dimension)this.core.getLabelImageSize());
        final CoreController coreController = this.core;
        this.core.submit(new Runnable(){
            Unmarshaller unmarsh = null;
            {
                try {
                    JAXBContext jAXBContext = JaxbCache.getContext(ObjectFactory.class);
                    this.unmarsh = jAXBContext.createUnmarshaller();
                }
                catch (JAXBException jAXBException) {
                    jAXBException.printStackTrace();
                    coreController.logEvent(Level.WARNING, "Unable to determine version numbers", (Throwable)jAXBException);
                }
            }

            private void handleProjectDirectory(File file) {
                for (String string : VERSION_DIRS) {
                    this.handleVersionDirectory(new File(String.format("%s/%s", file.getAbsolutePath(), string)));
                }
            }

            private void handleVersionDirectory(File file) {
                if (file == null) {
                    return;
                }
                if (!file.isDirectory()) {
                    return;
                }
                for (File file2 : file.listFiles()) {
                    this.loadVersionFile(file2);
                }
            }

            private void loadVersionFile(File file) {
                if (this.unmarsh == null) {
                    return;
                }
                try {
                    Object object = this.unmarsh.unmarshal(file);
                    if (object instanceof JAXBElement) {
                        object = ((JAXBElement)JAXBElement.class.cast(object)).getValue();
                    }
                    if (object instanceof VersionType) {
                        About.this.model.addVersion((VersionType)VersionType.class.cast(object));
                    }
                }
                catch (JAXBException jAXBException) {
                    // empty catch block
                }
            }

            public void run() {
                File file = new File(About.this.core.getResourceDirectory());
                if (!file.exists() || !file.isDirectory()) {
                    return;
                }
                try {
                    for (File file2 : file.listFiles()) {
                        this.handleProjectDirectory(file2);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                About.this.model.addVersion("Java Runtime", System.getProperty("java.version", "Unknown"));
            }
        });
        return 0;
    }

    public static void main(String[] stringArray) throws Throwable {
        Class<?> clazz = Class.forName("ds.plugin.replay.OpReplayDriver");
        Method method = clazz.getMethod("main", stringArray.getClass());
        method.invoke(null, new Object[]{stringArray});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class VersionTableModel
    extends AbstractEnumeratedTableModel<VersionTableColumns>
    implements TableModel {
        List<VersionInformation> versions;

        public VersionTableModel() {
            super(VersionTableColumns.class);
            this.versions = new Vector<VersionInformation>();
        }

        @Override
        public int getRowCount() {
            return this.versions.size();
        }

        public String getColumnName(VersionTableColumns versionTableColumns) {
            switch (versionTableColumns) {
                case NAME: {
                    return "Product";
                }
                case VERSION: {
                    return "Version";
                }
            }
            return "";
        }

        public Class<?> getColumnClass(VersionTableColumns versionTableColumns) {
            switch (versionTableColumns) {
                case NAME: {
                    return String.class;
                }
                case VERSION: {
                    return String.class;
                }
            }
            return null;
        }

        public Object getValueAt(int n, VersionTableColumns versionTableColumns) {
            VersionInformation versionInformation = this.versions.get(n);
            if (versionInformation == null) {
                return null;
            }
            switch (versionTableColumns) {
                case NAME: {
                    return versionInformation.name;
                }
                case VERSION: {
                    return versionInformation.version;
                }
            }
            return null;
        }

        public void addVersion(VersionType versionType) {
            this.addVersion(new VersionInformation(versionType));
        }

        public void addVersion(String string, String string2) {
            this.addVersion(new VersionInformation(string, string2));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addVersion(VersionInformation versionInformation) {
            int n;
            VersionTableModel versionTableModel = this;
            synchronized (versionTableModel) {
                n = this.versions.size();
                this.versions.add(versionInformation);
            }
            this.fireTableRowsInserted(n, n);
            this.fireTableRowsUpdated(0, n);
        }
    }

    public class VersionInformation {
        public final String name;
        public final String version;

        public VersionInformation(VersionType versionType) {
            this.name = versionType.getValue();
            this.version = String.format("%d.%d.%d.%s", versionType.getMajor(), versionType.getMinor(), versionType.getFix(), versionType.getBuild());
        }

        public VersionInformation(String string, String string2) {
            this.name = string;
            this.version = string2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VersionTableColumns {
        NAME,
        VERSION;

    }
}

