/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.terminal;

import ddb.dsz.core.controller.CommandInfo;
import ddb.dsz.core.controller.CommandSet;
import ddb.dsz.library.console.CommandCompletionAction;
import ddb.dsz.library.console.ConsoleOutputPane;
import ddb.dsz.library.console.ParsedCommandLine;
import ddb.dsz.plugin.terminal.Terminal;
import ddb.util.StringCompletor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerminalCompletionAction
extends CommandCompletionAction {
    static final Pattern TGT = Pattern.compile("dst=([^\\s]*)", 2);
    static final Pattern TGT_PREFIX = Pattern.compile("\\s*dst=([^\\s]*)\\s.*", 2);
    static final Pattern LOCAL_PREFIX = Pattern.compile("\\s*local\\s.*", 2);
    private JTextField commandLine;
    private CommandSet commands;
    private final Terminal terminal;

    public TerminalCompletionAction(Terminal terminal, CommandSet commandSet) {
        this.commandLine = terminal.getCommandLine();
        this.commands = commandSet;
        this.terminal = terminal;
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(ActionEvent actionEvent) {
        void var18_34;
        Object object;
        boolean bl;
        String string;
        String string2;
        if (this.terminal.isInPromptMode()) {
            return;
        }
        int n = this.commandLine.getText().length();
        int n2 = this.commandLine.getCaretPosition();
        String string3 = null;
        String string4 = null;
        try {
            string3 = this.commandLine.getText(0, n2);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return;
        }
        try {
            string4 = this.commandLine.getText(n2, n - n2);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return;
        }
        if (string3.startsWith(".")) {
            if (string3.indexOf(" ") != -1) {
                this.terminal.helpBuiltinCommand(string3);
                return;
            }
            this.terminal.completeBuiltinCommand(string3, string4);
            return;
        }
        Matcher matcher = TGT.matcher(string3);
        if (matcher.matches() && this.commandLine != null) {
            String string5 = matcher.group(1);
            String string6 = this.terminal.getTargetForPrefix(string5);
            if (string6 != null) {
                string3 = string3.substring(0, string3.length() - string5.length());
                String string7 = String.format("%s%s%s ", string3, string6, string4);
                this.commandLine.setText(string7);
                int n3 = string3.length() + string6.length();
                this.commandLine.setCaretPosition(n3);
            }
            return;
        }
        ParsedCommandLine parsedCommandLine = new ParsedCommandLine(string3, this.commands);
        boolean bl2 = parsedCommandLine.endsWithSpace();
        String string8 = parsedCommandLine.getLastWord();
        String string9 = parsedCommandLine.getLineWithoutLastWord();
        if (bl2) {
            string2 = parsedCommandLine.getCommandLine();
            string = "";
        } else {
            string2 = string9;
            string = string8;
        }
        parsedCommandLine.parseLine(string2);
        boolean bl3 = parsedCommandLine.getCommandName() != null && !parsedCommandLine.getCommandName().equals("");
        boolean bl4 = false;
        HashSet<String> hashSet = new HashSet<String>();
        if (bl3) {
            for (CommandInfo commandInfo : parsedCommandLine.getCommandInfo()) {
                hashSet.add(commandInfo.getOptionPrefix());
            }
        }
        boolean bl5 = false;
        if (string != null) {
            for (String object22 : hashSet) {
                if (object22 == null || !string.startsWith(object22)) continue;
                bl5 = true;
                break;
            }
        }
        if (bl3 && hashSet.size() > 0 && bl5) {
            bl4 = true;
        }
        if (bl = bl3 && !bl4) {
            void var18_30;
            Object var18_27 = null;
            Matcher matcher2 = TGT_PREFIX.matcher(parsedCommandLine.getCommandLine());
            if (matcher2.matches()) {
                String string5 = matcher2.group(1);
            } else {
                matcher2 = LOCAL_PREFIX.matcher(parsedCommandLine.getCommandLine());
                if (matcher2.matches()) {
                    String string6 = "localhost";
                }
            }
            this.terminal.requestHelpStatement(parsedCommandLine, (String)var18_30);
            return;
        }
        Object var18_31 = null;
        if (bl4) {
            Vector vector = new Vector();
            object = parsedCommandLine.getCommandInfo();
            Vector<String> vector2 = new Vector<String>();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object object2 = (CommandInfo)iterator.next();
                for (String string7 : object2.getOptions()) {
                    vector2.add(object2.getOptionPrefix() + string7);
                }
            }
            for (Object object2 : parsedCommandLine.getOptions()) {
                vector2.remove(object2);
            }
            vector.addAll(StringCompletor.complete((String)string, vector2));
        } else {
            List list = StringCompletor.complete((String)string, (Collection)this.commands.getAllCommands());
        }
        switch (var18_34.size()) {
            case 1: {
                this.commandLine.setText(string2 + var18_34.get(0).toString() + " " + string4);
                int n3 = string2.length() + var18_34.get(0).toString().length() + 1;
                this.commandLine.setCaretPosition(n3);
                return;
            }
            case 0: {
                Toolkit.getDefaultToolkit().beep();
                break;
            }
            default: {
                Collections.sort(var18_34);
                if (string == null) {
                    string = "";
                }
                if (!((String)(object = this.findLongestCommonPrefix((List<?>)var18_34, string))).equals(string)) {
                    this.commandLine.setText(string2 + (String)object + string4);
                    int n4 = string2.length() + ((String)object).length();
                    this.commandLine.setCaretPosition(n4);
                    return;
                }
                if (bl4) {
                    this.printMultipleOptionCompletions((Collection<?>)var18_34, parsedCommandLine.getCommandName());
                    break;
                }
                this.printMultipleCommandAndPrefixCompletions((List<CommandInfo>)var18_34);
                break;
            }
        }
    }

    private String findLongestCommonPrefix(List<?> list, String string) {
        String string2 = string;
        if (string == null) {
            string2 = "";
        }
        int n = string2.length();
        String string3 = "";
        if (list.size() > 0) {
            string3 = list.get(0).toString();
        }
        for (int i = string2.length(); i < string3.length(); ++i) {
            char c;
            try {
                c = string3.charAt(i);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return string3.substring(0, n);
            }
            Iterator<?> iterator = list.iterator();
            iterator.next();
            while (iterator.hasNext()) {
                char c2;
                String string4 = iterator.next().toString();
                try {
                    c2 = string4.charAt(i);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    return string3.substring(0, n);
                }
                if (c2 == c) continue;
                return string3.substring(0, n);
            }
            ++n;
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printMultipleCommandAndPrefixCompletions(List<CommandInfo> list) {
        int n = 20;
        for (CommandInfo object2 : list) {
            if (object2.getName().length() <= n) continue;
            n = object2.getName().length();
        }
        int n2 = 80 / (6 + n);
        if (n > 25) {
            n2 = 2;
        } else if (n < 15) {
            n2 = 4;
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        String string = String.format("%6s%%-%ds", " ", n);
        for (CommandInfo commandInfo : list) {
            switch (commandInfo.getType()) {
                case PREFIX: 
                case ALIASPREFIX: {
                    stringBuilder.append(String.format(string, commandInfo.getName()));
                    if (++n3 % n2 != 0) break;
                    stringBuilder.append("\n");
                    break;
                }
                case COMMAND: {
                    stringBuilder2.append(String.format(string, commandInfo.getName()));
                    if (++n4 % n2 != 0) break;
                    stringBuilder2.append("\n");
                    break;
                }
                case ALIAS: {
                    stringBuilder3.append(String.format(string, commandInfo.getName()));
                    if (++n5 % n2 != 0) break;
                    stringBuilder3.append("\n");
                }
            }
        }
        Terminal terminal = this.terminal;
        synchronized (terminal) {
            this.terminal.appendTimestampedString(this.commandLine.getText() + "\n", ConsoleOutputPane.OutputLevel.BOLD);
            if (stringBuilder.length() > 0) {
                this.terminal.appendOutputMessage("Prefixes:\n", ConsoleOutputPane.OutputLevel.NOTICE);
                this.terminal.appendToOutput(stringBuilder.toString());
                this.terminal.appendToOutput("\n");
            }
            if (stringBuilder2.length() > 0) {
                this.terminal.appendOutputMessage("Commands:\n", ConsoleOutputPane.OutputLevel.NOTICE);
                this.terminal.appendToOutput(stringBuilder2.toString());
                this.terminal.appendToOutput("\n");
            }
            if (stringBuilder3.length() > 0) {
                this.terminal.appendOutputMessage("Aliases:\n", ConsoleOutputPane.OutputLevel.NOTICE);
                this.terminal.appendToOutput(stringBuilder3.toString());
                this.terminal.appendToOutput("\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printMultipleOptionCompletions(Collection<?> collection, String string) {
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (Object object2 : collection) {
            stringBuilder.append((String)object2 + "\t");
            if (++n % 3 != 0) continue;
            stringBuilder.append("\n");
        }
        object2 = this.terminal;
        synchronized (object2) {
            this.terminal.appendTimestampedString(this.commandLine.getText() + "\n", ConsoleOutputPane.OutputLevel.BOLD);
            this.terminal.appendOutputMessage("Options for '" + string + "'\n", ConsoleOutputPane.OutputLevel.NOTICE);
            this.terminal.appendToOutput(stringBuilder.toString());
            this.terminal.appendToOutput("\n");
        }
    }

    private String printCompletionsToStringBuffer(Vector<?> vector) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<?> iterator = vector.iterator();
        int n = 1;
        while (iterator.hasNext()) {
            stringBuilder.append((String)iterator.next() + " ");
            if (n++ != 8) continue;
            n = 0;
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

