#define DM_PROCESS_STARTED 0x1 
#define DM_CREATEPROCESS_FAILED 0x2
#define DM_EXCEPTION 0x3
#define DM_GETTHREADCONTEXT_FAILED 0x4
#define DM_DEBUGACTIVEPROCESS_FAILED 0x5
#define DM_DEBUGSETPROCESSKILLONEXIT_FAILED 0x6

#define READ_ACCESS_VIOLATION 0x1
#define WRITE_ACCESS_VIOLATION 0x2
#define DEP_ACCESS_VIOLATION 0x3

struct ExceptionInfo
{
	DWORD ExceptionCode;
	char* ExceptionMessage;
	DWORD ExceptionAddress;
	DWORD AccessViolationType;
	DWORD AccessViolationAddress;
	CONTEXT Context;
	BYTE* ExceptionInstructions;
	int ExceptionInstructionCount;

	ExceptionInfo()
		: ExceptionCode(0), ExceptionMessage(0), ExceptionAddress(0),
		AccessViolationType(0), AccessViolationAddress(0), Context(*new CONTEXT()),
		ExceptionInstructions(0), ExceptionInstructionCount(0)
	{
	}	
};

struct DebuggerMessage
{
	int MessageType;
	char* Message;
	ExceptionInfo Exception;

	DebuggerMessage(int MessageType)
		: MessageType(MessageType)
	{
	}

	DebuggerMessage(int MessageType, char* Message)
		: MessageType(MessageType), Message(Message)
	{
	}

	DebuggerMessage(ExceptionInfo Exception)
		: MessageType(DM_EXCEPTION), Message(0) ,Exception(Exception)
	{

	}
};

class DebugInfo
{
public:
	char* Path;
	int ProcessId;
	void (_stdcall *Callback)(DebuggerMessage);
	HANDLE Event;

	DebugInfo(char* Path, void (_stdcall *Callback)(DebuggerMessage), HANDLE Event)
		: Path(Path), Callback(Callback), Event(Event), ProcessId(0)
	{
	}

	DebugInfo(int ProcessId, void (_stdcall *Callback)(DebuggerMessage), HANDLE Event)
		: Path(0), Callback(Callback), Event(Event), ProcessId(ProcessId)
	{
	}

	DebugInfo()
		: Path(0), Callback(0), Event(0)
	{
	}
};

extern "C" 
{
	void _declspec(dllexport) __cdecl StartProcess(char* Path, 
		void (_stdcall *Callback)(DebuggerMessage), int Id);

	void _declspec(dllexport) __cdecl Attach(int ProcessId, 
		void (_stdcall *Callback)(DebuggerMessage), int Id);

	void _declspec(dllexport) __cdecl Stop(int Id);
}