﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;
using System.Xml.Serialization;
using System.Diagnostics;
using Debugger;
using System.Text.RegularExpressions;
using System.Threading;

namespace DebuggerTest
{
    class Program
    {
        static void TestDebugger()
        {
            var disassembler = new DisassemblerWrapper();

            var debugger = new NativeDebugger();            
            debugger.ExceptionCaught += (s, e) =>
            {
                Console.WriteLine("{0:X8}: {1}",
                    e.Exception.ExceptionAddress, e.Exception.ExceptionMessage);

                var context = e.Exception.Context;

                Console.WriteLine("Edi = {0:X8}\r\n" +
                    "Esi = {1:X8}\r\n" +
                    "Ebx = {2:X8}\r\n" +
                    "Edx = {3:X8}\r\n" +
                    "Ecx = {4:X8}\r\n" +
                    "Eax = {5:X8}\r\n" +
                    "Ebp = {6:X8}\r\n" +
                    "Esp = {7:X8}\r\n" +
                    "Eip = {8:X8}\r\n",
                    context.Edi, context.Esi, context.Ebx, context.Edx,
                    context.Ecx, context.Eax, context.Ebp, context.Esp,
                    context.Eip);

                Console.WriteLine(e.Exception.DisassembleInstructions());

                //Console.WriteLine(disassembler.Disassemble(e.Exception.ExceptionInstructions
            };

            //debugger.Attach(2108);

            //System.Threading.Thread.Sleep(5000);

            //debugger.Stop();


            debugger.StartProcess(@"notepad.exe");
            //debugger.Attach(3636);

            System.Threading.Thread.Sleep(45000);

            debugger.Stop();
        }

        static void Main(string[] args)
        {
            TestDebugger();

            Console.WriteLine("Done");
            Console.ReadLine();
        }
    }
}
