﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;
using System.Reflection;
using System.IO;
using System.Diagnostics;
using Debugger;

namespace FuzzTalk.Actions
{
    [Serializable]
    public class AttachDebugger : DebuggerAction
    {
        public static Dictionary<string, NativeDebugger> DebuggerDictionary = new Dictionary<string, NativeDebugger>();

        private DirectoryInfo _dumpDirectory;

        [XmlIgnore]
        public DirectoryInfo DumpDirectory
        {
            get { return _dumpDirectory; }
            set { _dumpDirectory = value; }
        }

        public override void Process(ActionInterpreter Interpreter)
        {
            //_dumpDirectory = new DirectoryInfo(@".\Dumps_" + DateTime.Now.Ticks);

            //if (!_dumpDirectory.Exists)
            //    _dumpDirectory.Create();

            //var watcher = new FileSystemWatcher(_dumpDirectory.FullName)
            //{
            //    Filter = "*.dmp"
            //};

            //watcher.Created += (o, e) =>
            //{
          
            //};
            //watcher.EnableRaisingEvents = true;

            foreach (string name in ProcessNames.Split(new[] { ',' }, StringSplitOptions.RemoveEmptyEntries))
            {
                Console.WriteLine("Attempting to attach to {0}", name);

                foreach (var p in System.Diagnostics.Process.GetProcessesByName(name))
                {
                    var debugger = new NativeDebugger();
                    debugger.ExceptionCaught += (s, e) =>
                    {
                        if (!string.IsNullOrEmpty(e.Exception.ExceptionMessage))
                            ActionHelper.Try<IOException>(() =>
                                Program.Log.AddEntry(e.Exception.ToString()));
                    };

                    debugger.Attach(p.Id);                    

                    DebuggerInstances.Add(debugger);

                    Console.WriteLine("Debugger attached to {0}", p.Id);
                }
            }
        }        
    }

    
}
