﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;

namespace FuzzTalk.Actions
{
    [Serializable]
    public abstract class Connect : FuzzTalkAction
    {
        private string _host;

        [XmlAttribute]
        public string Host
        {
            get { return _host; }
            set { _host = value; }
        }

        private int _port = 0;

        [XmlAttribute]
        public int Port
        {
            get { return _port; }
            set { _port = value; }
        }

        public override void Process(ActionInterpreter Interpreter)
        {
            if (Log)
                Program.Log.AddEntry("Connect: " + Name);

            try
            {
                CreateClient();
            }
            catch (System.Net.Sockets.SocketException ex)
            {
                Program.Log.AddEntry("Connect Error:\r\n\r\n" + ex);
            }            
        }

        public abstract void CreateClient();

        public abstract void SendData(byte[] Data);

        public abstract byte[] ReceiveData();

        public abstract void Close();
    }
}
