﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Xml.Serialization;
using System.Diagnostics;
using System.Reflection;
using Debugger;

namespace FuzzTalk.Actions
{
    [Serializable]
    public abstract class DebuggerAction : FuzzTalkAction
    {
        private string _debuggerPath;

        [XmlIgnore]
        public string DebuggerPath
        {
            get { return _debuggerPath; }
            set { _debuggerPath = value; }
        }

        private List<NativeDebugger> _debuggerInstances = new List<NativeDebugger>();

        [XmlIgnore]
        public List<NativeDebugger> DebuggerInstances
        {
            get { return _debuggerInstances; }
        }

        private string _processName;

        [XmlAttribute]
        public string ProcessNames
        {
            get { return _processName; }
            set { _processName = value; }
        }

        public DebuggerAction()
        {
            _debuggerPath = new FileInfo(Assembly.GetExecutingAssembly().Location).DirectoryName +
                @"\Resources\Debugger.exe";
        }
    }
}
