﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net.Sockets;

namespace FuzzTalk.Actions
{
    [Serializable]
    public class TcpConnect : Connect
    {
        private NetworkStream _stream;
        private TcpClient _client;

        public override void CreateClient()
        {
            _client = new TcpClient();
            _client.SendTimeout = 10000;
            _client.ReceiveTimeout = 10000;
            _client.Connect(Host, Port);
            _stream = _client.GetStream();
        }

        

        public override void SendData(byte[] Data)
        {
            try
            {
                _stream.Write(Data, 0, Data.Length);
            }
            catch
            {
                try
                {
                    Close();
                }
                catch { }
                

                throw;
            }           
        }

        public override byte[] ReceiveData()
        {
            try
            {
                var buffer = new byte[0];
                var tempBuffer = new byte[8192];

                var len = 0;

                //len = _stream.Read(tempBuffer, 0, tempBuffer.Length);
                //return tempBuffer.Take(len).ToArray();

                Action concatBuffer = () => buffer = buffer.Concat(tempBuffer.Take(len)).ToArray();

                while ((len = _stream.Read(tempBuffer, 0, tempBuffer.Length)) == tempBuffer.Length)
                    concatBuffer();

                concatBuffer();

                return buffer;
            }
            catch
            {
                try
                {
                    Close();
                }
                catch { }


                throw;
            }          

        }

        public override void Close()
        {
            if (_stream != null)
                _stream.Close();

            if (_client != null)
                _client.Close();
        }
    }
}
