﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using FuzzTalk.DataAnalysis;

namespace FuzzTalk
{
    public struct MutatedByte
    {
        private int _offset;

        public int Offset
        {
            get { return _offset; }
            set { _offset = value; }
        }

        private int _oldValue;

        public int OldValue
        {
            get { return _oldValue; }
            set { _oldValue = value; }
        }

        private int _newValue;

        public int NewValue
        {
            get { return _newValue; }
            set { _newValue = value; }
        }

        public MutatedByte(int Offset, int OldValue, int NewValue)
        {
            _offset = Offset;
            _oldValue = OldValue;
            _newValue = NewValue;
        }
    }

    public abstract class ByteMutator
    {
        private byte[] _bytes;

        public byte[] Bytes
        {
          get { return _bytes; }
          set { _bytes = value; }
        }

        private byte[] _mutatedBytes;

        public byte[] MutatedBytes
        {
          get { return _mutatedBytes; }
          set { _mutatedBytes = value; }
        }

        private List<MutatedByte> _mutationActivity;

        public List<MutatedByte> MutationActivity
        {
            get { return _mutationActivity; }
            set { _mutationActivity = value; }
        }

        public abstract void Mutate();
    }

    public class RandomByteMutator : ByteMutator
    {
        private static Random _random = new Random();

        private int _start = 0;

        public int Start
        {
            get { return _start; }
            set { _start = value; }
        }

        private int _end = 0;

        public int End
        {
            get { return _end; }
            set { _end = value; }
        }

        private bool _mutateRange = false;

        public bool MutateRange
        {
            get { return _mutateRange; }
            set { _mutateRange = value; }
        }

        //private int _randomizeChance = 250;

        //public int RandomizeChance
        //{
        //    get { return _randomizeChance; }
        //    set { _randomizeChance = value; }
        //}

        private int _randomCount = 5;

        public int RandomCount
        {
            get { return _randomCount; }
            set { _randomCount = value; }
        }

        public override void Mutate()
        {
            MutationActivity = new List<MutatedByte>();
            MutatedBytes = new byte[Bytes.Length];

            Array.Copy(Bytes, MutatedBytes, Bytes.Length);

            for (int i = 0; i < _randomCount; i++)
            {
                var index = _mutateRange ?
                    _random.Next(_start, _end) :
                    _random.Next(0, MutatedBytes.Length);

                var b = (byte)_random.Next();
                MutationActivity.Add(new MutatedByte(index, Bytes[index], b));
                MutatedBytes[index] = b;                
            }

            MutationActivity = MutationActivity.OrderBy(x => x.Offset).ToList();

            //for (int i = _mutateRange ? _start : 0; i < (_mutateRange ? _end : Bytes.Length); i++)
            //{
            //    if (_random.Next(0, 10000) > _randomizeChance)
            //        continue;
            //    else
            //    {
            //        var b = (byte)_random.Next();
            //        MutationActivity.Add(new MutatedByte(i, Bytes[i], b));
            //        MutatedBytes[i] = b;
            //    }
                    
            //}
        }
    }

    public class RandomStringOverflowMutator : ByteMutator
    {
        private static Random _random = new Random();

        private char _stringChar = (char)0x41;

        private int _minStringLength = 256;

        public int MinStringLength
        {
            get { return _minStringLength; }
            set { _minStringLength = value; }
        }

        private int _maxStringLength = 10000;

        public int MaxStringLength
        {
            get { return _maxStringLength; }
            set { _maxStringLength = value; }
        }

        //private int _stringCount = 1;

        //public int StringCount
        //{
        //    get { return _stringCount; }
        //    set { _stringCount = value; }
        //}

        private StringMatch[] _matches = null;

        public override void Mutate()
        {
            _stringChar = (char)_random.Next(0, 0x80);

            MutationActivity = new List<MutatedByte>();

            var overflowString = new string(_stringChar,
                _random.Next(_minStringLength, _maxStringLength + 1));

            if (_matches == null)
            {
                var finder = new StringFinder(Bytes) { AlphaOnly = true };

                _matches = finder.FindStrings();
            }

            var index = _matches[_random.Next(0, _matches.Length)].Index;

            var bytes2 = new List<byte>(Bytes);

            //for (int i = overflowString.Length - 1; i >= 0; i--)
            //    bytes2.Insert(index, (byte)overflowString[i]);

            bytes2.InsertRange(index, ASCIIEncoding.ASCII.GetBytes(overflowString));

            MutatedBytes = bytes2.ToArray();

            //_matches[index].
        }
    }
}
