﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Reflection;

namespace FuzzTalk
{
    public static class ObjectGraph
    {
        // turn into overload for private function
        static List<object> WalkedObjects = new List<object>();

        public static void WalkProperties(object Target, Action<object, PropertyInfo> ObjectAction)
        {
            WalkedObjects.Add(Target);

            var t = Target.GetType();

            foreach (var property in t.GetProperties())
            {
                ObjectAction(Target, property);

                if (property.GetIndexParameters().Length != 0)
                    continue;

                //if (t == typeof(string) && property.PropertyType == typeof(char))
                //    continue;


                var propertyValue = property.GetValue(Target, null);

                if (propertyValue != null &&
                    !WalkedObjects.Contains(propertyValue))
                    WalkProperties(propertyValue, ObjectAction);
            }

            if (t.GetInterface("IEnumerable") != null)
            {
                foreach (var i in Target as System.Collections.IEnumerable)
                    if (!WalkedObjects.Contains(i))
                        WalkProperties(i, ObjectAction);
            }
        }
    }
}
