---
title: "PowerShell Exploiter"
draft: false
description: "Exploits PowerShell Remoting"
tags: ["exploiter", "powershell", "brute force"]
pre: "<i class='fa fa-terminal'></i> "
---

## PowerShell Remoting

[PowerShell Remoting](
https://docs.microsoft.com/en-us/powershell/scripting/learn/remoting/winrmsecurity)
is a PowerShell feature that enables connecting to Windows machines remotely in
order to execute PowerShell commands on them. It is commonly used by
administrators to manage multiple systems in a network.

## Exploitation

Attackers that can successfully authenticate via PowerShell Remoting are able
to execute arbitrary commands on the victim machine. Infection Monkey's
PowerShell exploiter uses brute-force to attempt to propagate to a victim
via PowerShell Remoting.

![PowerShell Configuration](
/images/island/configuration-page/powershell-exploiter-configuration.png
"PowerShell Configuration")

### Credentials used

The PowerShell exploiter can be run from both Linux and Windows attackers. On
Windows attackers, the exploiter has the ability to use the cached username
and/or password from the current user. When attacking from Linux or Windows,
the exploiter uses all combinations of [user-configured credentials](
/usage/configuration/credentials), as well as credentials collected from other
victims. Different combinations of credentials are attempted in the following
order:

1. **Cached username and password (Windows attacker only)** - The exploiter
   uses the stored credentials of the current user to attempt to log into
   the victim machine.

1. **Brute force usernames with blank passwords** - Windows allows you to
   configure a user with a blank/empty password. The exploiter attempts to
   log into the victim machine using usernames set in the
   [configuration](/usage/configuration/credentials) or stolen from other
   victims, and a blank password.

   In order for the attacker to connect with a blank password, the victim must
   have enabled basic authentication, http and no encryption.

1. **Brute force usernames with cached password (Windows attacker only)** - The
   exploiter attempts to log into the victim machine using usernames
   set in the [configuration](/usage/configuration/credentials) or stolen from
   other victims, and the current user's cached password.

1. **Brute force usernames and passwords** - The exploiter attempts to use
   all combinations of usernames and passwords that were set in the
   [configuration](/usage/configuration/credentials) or stolen from other
   victims.

1. **Brute force usernames and LM hashes** - The exploiter attempts to use
   all combinations of usernames and LM hashes that were set in the
   [configuration](/usage/configuration/credentials) or stolen from other
   victims.

1. **Brute force usernames and NT hashes** - The exploiter attempts to use
   all combinations of usernames and NT hashes that were set in the
   [configuration](/usage/configuration/credentials) or stolen from other
   victims.

Note that techniques that use cached credentials, are only possible from
Windows attackers.

## Mitigation

1. Restrict PowerShell remote command execution.
1. Harden the credentials of relevant users by enforcing strong password
   policies.
1. Enable multi-factor authentication.

More information about how to remediate security concerns related to PowerShell
Remoting can be found [here](
https://docs.microsoft.com/en-us/powershell/scripting/learn/remoting/winrmsecurity).

## See also
- [PowerShell exploiter reference documentation](/reference/exploiters/powershell)
