---
title: "Zerologon"
draft: false
description: "Reference material for the Zerologon exploiter"
pre: "<i class='fas fa-right-to-bracket'></i> "
---
{{< table_of_contents >}}

## Supported operating systems

| Operating system | Attack from                 | Target                      |
| :--------------- | :-------------------------- | :-------------------------- |
| Linux            | {{< os-icon-supported >}}   | {{< os-icon-unsupported >}} |
| Windows          | {{< os-icon-supported >}}   | {{< os-icon-supported >}}   |

## Exploited CVEs

- {{% cve id=CVE-2020-1472 %}}

## Configuration

<!--
This documentation was autogenerated by passing the plugin's config-schema.json
through https://github.com/adobe/jsonschema2md. It was then modified by hand to
remove extraneous information.
-->

| Property                       | Type      | Required | Nullable       |
| :----------------------------- | :-------- | :------- | :------------- |
| [max\_attempts](#max_attempts) | `integer` | Optional | cannot be null |

### max\_attempts

The maximum number of authentication attempts to make. It takes 256 attempts, on average, to successfully authenticate.

`max_attempts`

* is optional

* Type: `integer`

* cannot be null

#### max\_attempts Constraints

**maximum**: the value of this number must smaller than or equal to: `5000`

**minimum**: the value of this number must greater than or equal to: `1`

#### max\_attempts Default Value

The default value is:

```json
2000
```

## Acknowledgements

* The logic for the Zerologon exploiter is based on implementations by
[@dirkjanm](https://github.com/dirkjanm/CVE-2020-1472/) and [@risksense](
https://github.com/risksense/zerologon).
