/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.config;

import java.util.prefs.Preferences;
import net.azib.ipscan.fetchers.Fetcher;
import net.azib.ipscan.fetchers.HostnameFetcher;
import net.azib.ipscan.fetchers.IPFetcher;
import net.azib.ipscan.fetchers.PingFetcher;
import org.eclipse.swt.graphics.Point;

public class GUIConfig {
    private Preferences preferences;
    public boolean isFirstRun;
    public boolean versionCheckEnabled;
    public String lastRunVersion;
    public long lastVersionCheck;
    public int activeFeeder;
    public DisplayMethod displayMethod;
    public boolean showScanStats;
    public boolean askScanConfirmation;
    public int[] mainWindowSize;
    public int[] mainWindowPosition;
    public boolean isMainWindowMaximized;
    public int[] detailsWindowSize;

    GUIConfig(Preferences preferences) {
        this.preferences = preferences;
        this.load();
    }

    private void load() {
        this.isFirstRun = this.preferences.getBoolean("firstRun", true);
        this.versionCheckEnabled = this.preferences.getBoolean("versionCheckEnabled", true);
        this.lastRunVersion = this.preferences.get("lastRunVersion", "Unknown");
        this.lastVersionCheck = this.preferences.getLong("lastVersionCheck", System.currentTimeMillis());
        this.activeFeeder = this.preferences.getInt("activeFeeder", 0);
        this.displayMethod = DisplayMethod.valueOf(this.preferences.get("displayMethod", DisplayMethod.ALL.toString()));
        this.showScanStats = this.preferences.getBoolean("showScanStats", true);
        this.askScanConfirmation = this.preferences.getBoolean("askScanConfirmation", true);
        this.isMainWindowMaximized = this.preferences.getBoolean("windowMaximized", false);
        this.mainWindowSize = new int[]{this.preferences.getInt("windowWidth", 800), this.preferences.getInt("windowHeight", 450)};
        this.mainWindowPosition = new int[]{this.preferences.getInt("windowX", 50), this.preferences.getInt("windowY", 85)};
        this.detailsWindowSize = new int[]{this.preferences.getInt("detailsWidth", 400), this.preferences.getInt("detailsHeight", 300)};
    }

    public void store() {
        this.preferences.putBoolean("firstRun", this.isFirstRun);
        this.preferences.putBoolean("versionCheckEnabled", this.versionCheckEnabled);
        this.preferences.put("lastRunVersion", this.lastRunVersion);
        this.preferences.putLong("lastVersionCheck", this.lastVersionCheck);
        this.preferences.putInt("activeFeeder", this.activeFeeder);
        this.preferences.put("displayMethod", this.displayMethod.toString());
        this.preferences.putBoolean("showScanStats", this.showScanStats);
        this.preferences.putBoolean("askScanConfirmation", this.askScanConfirmation);
        this.preferences.putBoolean("windowMaximized", this.isMainWindowMaximized);
        if (!this.isMainWindowMaximized) {
            this.preferences.putInt("windowWidth", this.mainWindowSize[0]);
            this.preferences.putInt("windowHeight", this.mainWindowSize[1]);
            this.preferences.putInt("windowX", this.mainWindowPosition[0]);
            this.preferences.putInt("windowY", this.mainWindowPosition[1]);
        }
        this.preferences.putInt("detailsWidth", this.detailsWindowSize[0]);
        this.preferences.putInt("detailsHeight", this.detailsWindowSize[1]);
    }

    public Point getDetailsWindowSize() {
        return new Point(this.detailsWindowSize[0], this.detailsWindowSize[1]);
    }

    public void setDetailsWindowSize(Point size) {
        this.detailsWindowSize = new int[]{size.x, size.y};
    }

    public Point getMainWindowSize() {
        return new Point(this.mainWindowSize[0], this.mainWindowSize[1]);
    }

    public void setMainWindowSize(Point size, boolean isMaximized) {
        if (!isMaximized) {
            this.mainWindowSize = new int[]{size.x, size.y};
        }
        this.isMainWindowMaximized = isMaximized;
    }

    public Point getMainWindowPosition() {
        return new Point(this.mainWindowPosition[0], this.mainWindowPosition[1]);
    }

    public void setMainWindowPosition(Point position, boolean isMaximized) {
        if (!isMaximized) {
            this.mainWindowPosition = new int[]{position.x, position.y};
        }
        this.isMainWindowMaximized = isMaximized;
    }

    public int getColumnWidth(Fetcher fetcher) {
        int width = this.preferences.getInt("columnWidth." + fetcher.getId(), 0);
        if (width == 0) {
            width = fetcher instanceof IPFetcher || fetcher instanceof HostnameFetcher ? 140 : (fetcher instanceof PingFetcher ? 60 : 90);
        }
        return width;
    }

    public void setColumnWidth(Fetcher fetcher, int width) {
        this.preferences.putInt("columnWidth." + fetcher.getId(), width);
    }

    public static enum DisplayMethod {
        ALL,
        ALIVE,
        PORTS;

    }
}

