/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.core.net;

import java.io.IOException;
import net.azib.ipscan.core.ScanningSubject;
import net.azib.ipscan.core.net.JavaPinger;
import net.azib.ipscan.core.net.PingResult;
import net.azib.ipscan.core.net.Pinger;
import net.azib.ipscan.fetchers.MACFetcher;

public class ARPPinger
implements Pinger {
    private MACFetcher macFetcher;
    private Pinger trigger;

    public ARPPinger(MACFetcher macFetcher, JavaPinger trigger) {
        this(macFetcher, (Pinger)(macFetcher.getClass().getSimpleName().startsWith("Win") ? null : trigger));
    }

    ARPPinger(MACFetcher macFetcher, Pinger trigger) {
        this.macFetcher = macFetcher;
        this.trigger = trigger;
    }

    @Override
    public String getId() {
        return "pinger.arp";
    }

    @Override
    public PingResult ping(ScanningSubject subject, int count) throws IOException {
        if (this.trigger != null) {
            count -= count / 2;
        }
        PingResult result = new PingResult(subject.getAddress(), count);
        for (int i = 0; i < count; ++i) {
            String mac;
            long start = System.currentTimeMillis();
            if (this.trigger != null) {
                result.merge(this.trigger.ping(subject, 1));
            }
            if ((mac = this.macFetcher.scan(subject)) == null) continue;
            result.addReply(System.currentTimeMillis() - start);
        }
        return result;
    }
}

