/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.core.net;

import java.io.IOException;
import java.net.ConnectException;
import net.azib.ipscan.config.ScannerConfig;
import net.azib.ipscan.core.ScanningSubject;
import net.azib.ipscan.core.net.PingResult;
import net.azib.ipscan.core.net.Pinger;

public class JavaPinger
implements Pinger {
    private int timeout;

    public JavaPinger(ScannerConfig config) {
        this.timeout = config.pingTimeout;
    }

    @Override
    public String getId() {
        return "pinger.java";
    }

    @Override
    public PingResult ping(ScanningSubject subject, int count) throws IOException {
        PingResult result = new PingResult(subject.getAddress(), count);
        for (int i = 0; i < count; ++i) {
            try {
                long start = System.currentTimeMillis();
                if (!subject.getAddress().isReachable(this.timeout)) continue;
                result.addReply(System.currentTimeMillis() - start);
                continue;
            }
            catch (ConnectException connectException) {
                // empty catch block
            }
        }
        return result;
    }
}

