/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.exporters;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.azib.ipscan.exporters.Exporter;
import net.azib.ipscan.exporters.ExporterException;

public class ExporterRegistry
implements Iterable<Exporter> {
    private Map<String, Exporter> exporters = new LinkedHashMap<String, Exporter>();

    public ExporterRegistry(List<Exporter> registeredExporters) {
        for (Exporter exporter : registeredExporters) {
            this.exporters.put(exporter.getFilenameExtension(), exporter);
        }
    }

    @Override
    public Iterator<Exporter> iterator() {
        return this.exporters.values().iterator();
    }

    public Exporter createExporter(String fileName) throws ExporterException {
        int extensionPos = fileName.lastIndexOf(46) + 1;
        String extension = fileName.substring(extensionPos);
        Exporter prototype = this.exporters.get(extension);
        if (prototype == null) {
            throw new ExporterException("exporter.unknown");
        }
        try {
            return (Exporter)prototype.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

