/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.fetchers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.azib.ipscan.core.ScanningSubject;
import net.azib.ipscan.fetchers.AbstractFetcher;
import net.azib.ipscan.fetchers.FetcherPrefs;
import net.azib.ipscan.gui.fetchers.MACFetcherPrefs;

public abstract class MACFetcher
extends AbstractFetcher {
    static final Pattern macAddressPattern = Pattern.compile("([a-fA-F0-9]{1,2}[-:]){5}[a-fA-F0-9]{1,2}");
    static final Pattern leadingZeroesPattern = Pattern.compile("(?<=^|-|:)([A-F0-9])(?=-|:|$)");
    String separator = this.getPreferences().get("separator", ":");

    @Override
    public String getId() {
        return "fetcher.mac";
    }

    @Override
    public final String scan(ScanningSubject subject) {
        String mac = (String)subject.getParameter("fetcher.mac");
        if (mac == null) {
            mac = this.resolveMAC(subject);
        }
        subject.setParameter("fetcher.mac", mac);
        return this.replaceSeparator(mac);
    }

    protected abstract String resolveMAC(ScanningSubject var1);

    static String bytesToMAC(byte[] bytes) {
        StringBuilder mac = new StringBuilder();
        for (byte b : bytes) {
            mac.append(String.format("%02X", b)).append(":");
        }
        if (!mac.isEmpty()) {
            mac.deleteCharAt(mac.length() - 1);
        }
        return mac.toString();
    }

    String extractMAC(String line) {
        Matcher m = macAddressPattern.matcher(line);
        return m.find() ? MACFetcher.addLeadingZeroes(m.group().toUpperCase()) : null;
    }

    String replaceSeparator(String mac) {
        return mac != null ? mac.replace(":", this.separator) : null;
    }

    private static String addLeadingZeroes(String mac) {
        return leadingZeroesPattern.matcher(mac).replaceAll("0$1");
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    @Override
    public Class<? extends FetcherPrefs> getPreferencesClass() {
        return MACFetcherPrefs.class;
    }
}

