/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui.actions;

import net.azib.ipscan.config.Labels;
import net.azib.ipscan.config.OpenersConfig;
import net.azib.ipscan.core.UserErrorException;
import net.azib.ipscan.core.state.ScanningState;
import net.azib.ipscan.core.state.StateMachine;
import net.azib.ipscan.fetchers.FetcherRegistry;
import net.azib.ipscan.gui.DetailsWindow;
import net.azib.ipscan.gui.EditOpenersDialog;
import net.azib.ipscan.gui.ResultTable;
import net.azib.ipscan.gui.StatusBar;
import net.azib.ipscan.gui.actions.OpenerLauncher;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class CommandsMenuActions {
    public Details details;
    public Delete delete;
    public Rescan rescan;
    public CopyIP copyIP;
    public CopyIPDetails copyIPDetails;
    public ShowOpenersMenu showOpenersMenu;
    public EditOpeners editOpeners;
    public SelectOpener selectOpener;

    public CommandsMenuActions(Details details, Delete delete, Rescan rescan, CopyIP copyIP, CopyIPDetails copyIPDetails, ShowOpenersMenu showOpenersMenu, EditOpeners editOpeners, SelectOpener selectOpener) {
        this.details = details;
        this.delete = delete;
        this.rescan = rescan;
        this.copyIP = copyIP;
        this.copyIPDetails = copyIPDetails;
        this.showOpenersMenu = showOpenersMenu;
        this.editOpeners = editOpeners;
        this.selectOpener = selectOpener;
    }

    static void checkSelection(ResultTable resultTable) {
        if (resultTable.getItemCount() <= 0) {
            throw new UserErrorException("commands.noResults");
        }
        if (resultTable.getSelectionIndex() < 0) {
            throw new UserErrorException("commands.noSelection");
        }
    }

    public static class Details
    implements Listener {
        private final ResultTable resultTable;
        private final DetailsWindow detailsWindow;

        public Details(ResultTable resultTable, DetailsWindow detailsWindow) {
            this.resultTable = resultTable;
            this.detailsWindow = detailsWindow;
            resultTable.addListener(31, this);
            resultTable.addListener(8, this);
        }

        @Override
        public void handleEvent(Event event) {
            if (event.type == 13 || this.resultTable.getSelectionIndex() >= 0 && (event.type == 8 || event.detail == 4)) {
                event.doit = false;
                CommandsMenuActions.checkSelection(this.resultTable);
                this.detailsWindow.open();
            }
        }
    }

    public static final class Delete
    implements Listener {
        private final ResultTable resultTable;
        private final StateMachine stateMachine;

        public Delete(ResultTable resultTable, StateMachine stateMachine) {
            this.resultTable = resultTable;
            this.stateMachine = stateMachine;
        }

        @Override
        public void handleEvent(Event event) {
            if (event.type == 1 && event.keyCode != 127) {
                return;
            }
            if (!this.stateMachine.inState(ScanningState.IDLE)) {
                return;
            }
            int firstSelection = this.resultTable.getSelectionIndex();
            if (firstSelection < 0) {
                return;
            }
            this.resultTable.remove(this.resultTable.getSelectionIndices());
            this.resultTable.setSelection(firstSelection);
            event.widget = this.resultTable;
            this.resultTable.notifyListeners(13, event);
        }
    }

    public static final class Rescan
    implements Listener {
        private final ResultTable resultTable;
        private final StateMachine stateMachine;

        public Rescan(ResultTable resultTable, StateMachine stateMachine) {
            this.resultTable = resultTable;
            this.stateMachine = stateMachine;
        }

        @Override
        public void handleEvent(Event event) {
            CommandsMenuActions.checkSelection(this.resultTable);
            this.stateMachine.rescan();
        }
    }

    public static final class CopyIP
    implements Listener {
        private final ResultTable resultTable;

        public CopyIP(ResultTable resultTable) {
            this.resultTable = resultTable;
        }

        @Override
        public void handleEvent(Event event) {
            if (event.type == 1) {
                if (event.keyCode != 99 && event.stateMask != SWT.MOD1 || this.resultTable.getSelectionIndex() < 0) {
                    return;
                }
            } else {
                CommandsMenuActions.checkSelection(this.resultTable);
            }
            Clipboard clipboard = new Clipboard(event.display);
            clipboard.setContents(new Object[]{this.resultTable.getItem(this.resultTable.getSelectionIndex()).getText()}, new Transfer[]{TextTransfer.getInstance()});
            clipboard.dispose();
        }
    }

    public static final class CopyIPDetails
    implements Listener {
        private final ResultTable resultTable;

        public CopyIPDetails(ResultTable resultTable) {
            this.resultTable = resultTable;
        }

        @Override
        public void handleEvent(Event event) {
            CommandsMenuActions.checkSelection(this.resultTable);
            Clipboard clipboard = new Clipboard(event.display);
            clipboard.setContents(new Object[]{this.resultTable.getSelectedResult().toString()}, new Transfer[]{TextTransfer.getInstance()});
            clipboard.dispose();
        }
    }

    public static final class ShowOpenersMenu
    implements Listener {
        private final Listener openersSelectListener;
        private final OpenersConfig openersConfig;

        public ShowOpenersMenu(OpenersConfig openersConfig, SelectOpener selectOpener) {
            this.openersConfig = openersConfig;
            this.openersSelectListener = selectOpener;
        }

        @Override
        public void handleEvent(Event event) {
            Menu openersMenu = (Menu)event.widget;
            MenuItem[] menuItems = openersMenu.getItems();
            for (int i = 2; i < menuItems.length; ++i) {
                menuItems[i].dispose();
            }
            int index = 0;
            for (Object name : this.openersConfig) {
                MenuItem menuItem = new MenuItem(openersMenu, 64);
                if (++index <= 9) {
                    name = (String)name + "\tCtrl+" + index;
                    menuItem.setAccelerator(SWT.MOD1 | 48 + index);
                }
                menuItem.setText((String)name);
                menuItem.setData(index);
                menuItem.addListener(13, this.openersSelectListener);
            }
        }
    }

    public static final class EditOpeners
    implements Listener {
        private final FetcherRegistry fetcherRegistry;
        private final OpenersConfig openersConfig;

        public EditOpeners(FetcherRegistry fetcherRegistry, OpenersConfig openersConfig) {
            this.fetcherRegistry = fetcherRegistry;
            this.openersConfig = openersConfig;
        }

        @Override
        public void handleEvent(Event event) {
            new EditOpenersDialog(this.fetcherRegistry, this.openersConfig).open();
        }
    }

    public static final class SelectOpener
    implements Listener {
        private final StatusBar statusBar;
        private final ResultTable resultTable;
        private final OpenerLauncher openerLauncher;
        private final OpenersConfig openersConfig;

        public SelectOpener(OpenersConfig openersConfig, StatusBar statusBar, ResultTable resultTable, OpenerLauncher openerLauncher) {
            this.openersConfig = openersConfig;
            this.statusBar = statusBar;
            this.resultTable = resultTable;
            this.openerLauncher = openerLauncher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleEvent(Event event) {
            MenuItem menuItem = (MenuItem)event.widget;
            String name = menuItem.getText();
            int indexOf = name.lastIndexOf(9);
            if (indexOf >= 0) {
                name = name.substring(0, indexOf);
            }
            OpenersConfig.Opener opener = this.openersConfig.getOpener(name);
            int[] selectionIndices = this.resultTable.getSelectionIndices();
            if (selectionIndices.length == 0) {
                throw new UserErrorException("commands.noSelection");
            }
            for (int i : selectionIndices) {
                try {
                    this.statusBar.setStatusText(Labels.getLabel("state.opening") + name);
                    this.openerLauncher.launch(opener, i);
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.statusBar.setStatusText(null);
                }
            }
        }
    }
}

