/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import org.eclipse.swt.graphics.ImageLoaderListener;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.NativeImageLoader;

public class ImageLoader {
    public ImageData[] data;
    public int logicalScreenWidth;
    public int logicalScreenHeight;
    public int backgroundPixel;
    public int repeatCount;
    public int compression;
    List<ImageLoaderListener> imageLoaderListeners;

    public ImageLoader() {
        this.reset();
    }

    void reset() {
        this.data = null;
        this.logicalScreenWidth = 0;
        this.logicalScreenHeight = 0;
        this.backgroundPixel = -1;
        this.repeatCount = 1;
        this.compression = -1;
    }

    public ImageData[] load(InputStream stream) {
        this.load(stream, 100, 100);
        return this.data;
    }

    List<DPIUtil.ElementAtZoom<ImageData>> load(InputStream stream, int fileZoom, int targetZoom) {
        if (stream == null) {
            SWT.error(4);
        }
        this.reset();
        List<DPIUtil.ElementAtZoom<ImageData>> images = NativeImageLoader.load(new DPIUtil.ElementAtZoom<InputStream>(stream, fileZoom), this, targetZoom);
        this.data = (ImageData[])images.stream().map(DPIUtil.ElementAtZoom::element).toArray(ImageData[]::new);
        return images;
    }

    public ImageData[] load(String filename) {
        this.load(filename, 100, 100);
        return this.data;
    }

    List<DPIUtil.ElementAtZoom<ImageData>> load(String filename, int fileZoom, int targetZoom) {
        if (filename == null) {
            SWT.error(4);
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileInputStream stream = new FileInputStream(filename);){
                return this.load(stream, fileZoom, targetZoom);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            SWT.error(39, e);
            return null;
        }
    }

    public boolean hasListeners() {
        return this.imageLoaderListeners != null && this.imageLoaderListeners.size() > 0;
    }

    public void notifyListeners(ImageLoaderEvent event) {
        if (!this.hasListeners()) {
            return;
        }
        int size = this.imageLoaderListeners.size();
        int i = 0;
        while (i < size) {
            ImageLoaderListener listener = this.imageLoaderListeners.get(i);
            listener.imageDataLoaded(event);
            ++i;
        }
    }
}

