/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.image.LEDataOutputStream;
import org.eclipse.swt.internal.image.TIFFModifiedHuffmanCodec;
import org.eclipse.swt.internal.image.TIFFRandomFileAccess;

final class TIFFDirectory {
    TIFFRandomFileAccess file;
    boolean isLittleEndian;
    ImageLoader loader;
    int depth;
    int subfileType;
    int imageWidth;
    int imageLength;
    int[] bitsPerSample;
    int compression;
    int photometricInterpretation;
    int[] stripOffsets;
    int samplesPerPixel;
    int rowsPerStrip;
    int[] stripByteCounts;
    int t4Options;
    int colorMapOffset;
    ImageData image;
    LEDataOutputStream out;
    static final int NO_VALUE = -1;
    static final short TAG_NewSubfileType = 254;
    static final short TAG_SubfileType = 255;
    static final short TAG_ImageWidth = 256;
    static final short TAG_ImageLength = 257;
    static final short TAG_BitsPerSample = 258;
    static final short TAG_Compression = 259;
    static final short TAG_PhotometricInterpretation = 262;
    static final short TAG_FillOrder = 266;
    static final short TAG_ImageDescription = 270;
    static final short TAG_StripOffsets = 273;
    static final short TAG_Orientation = 274;
    static final short TAG_SamplesPerPixel = 277;
    static final short TAG_RowsPerStrip = 278;
    static final short TAG_StripByteCounts = 279;
    static final short TAG_XResolution = 282;
    static final short TAG_YResolution = 283;
    static final short TAG_PlanarConfiguration = 284;
    static final short TAG_T4Options = 292;
    static final short TAG_ResolutionUnit = 296;
    static final short TAG_Software = 305;
    static final short TAG_DateTime = 306;
    static final short TAG_ColorMap = 320;
    static final int TYPE_BYTE = 1;
    static final int TYPE_ASCII = 2;
    static final int TYPE_SHORT = 3;
    static final int TYPE_LONG = 4;
    static final int TYPE_RATIONAL = 5;
    static final int FILETYPE_REDUCEDIMAGE = 1;
    static final int FILETYPE_PAGE = 2;
    static final int FILETYPE_MASK = 4;
    static final int OFILETYPE_IMAGE = 1;
    static final int OFILETYPE_REDUCEDIMAGE = 2;
    static final int OFILETYPE_PAGE = 3;
    static final int COMPRESSION_NONE = 1;
    static final int COMPRESSION_CCITT_3_1 = 2;
    static final int COMPRESSION_PACKBITS = 32773;
    static final int IFD_ENTRY_SIZE = 12;

    public TIFFDirectory(TIFFRandomFileAccess file, boolean isLittleEndian, ImageLoader loader) {
        this.file = file;
        this.isLittleEndian = isLittleEndian;
        this.loader = loader;
    }

    int decodePackBits(byte[] src, byte[] dest, int offsetDest) {
        int destIndex = offsetDest;
        int srcIndex = 0;
        while (srcIndex < src.length) {
            byte n = src[srcIndex];
            if (n >= 0) {
                System.arraycopy(src, ++srcIndex, dest, destIndex, n + 1);
                srcIndex += n + 1;
                destIndex += n + 1;
                continue;
            }
            if (n >= -127) {
                byte value = src[++srcIndex];
                int j = 0;
                while (j < -n + 1) {
                    dest[destIndex++] = value;
                    ++j;
                }
                ++srcIndex;
                continue;
            }
            ++srcIndex;
        }
        return destIndex - offsetDest;
    }

    int getEntryValue(int type, byte[] buffer, int index) {
        return this.toInt(buffer, index + 8, type);
    }

    void getEntryValue(int type, byte[] buffer, int index, int[] values) throws IOException {
        int size;
        int start = index + 8;
        int offset = this.toInt(buffer, start, 4);
        switch (type) {
            case 3: {
                size = 2;
                break;
            }
            case 4: {
                size = 4;
                break;
            }
            case 5: {
                size = 8;
                break;
            }
            case 1: 
            case 2: {
                size = 1;
                break;
            }
            default: {
                SWT.error(42);
                return;
            }
        }
        if (values.length * size > 4) {
            buffer = new byte[values.length * size];
            this.file.seek(offset);
            this.file.read(buffer);
            start = 0;
        }
        int i = 0;
        while (i < values.length) {
            values[i] = this.toInt(buffer, start + i * size, type);
            ++i;
        }
    }

    void decodePixels(ImageData image) throws IOException {
        byte[] imageData = new byte[(this.imageWidth * this.depth + 7) / 8 * this.imageLength];
        image.data = imageData;
        int destIndex = 0;
        int length = this.stripOffsets.length;
        int i = 0;
        while (i < length) {
            byte[] data = new byte[this.stripByteCounts[i]];
            this.file.seek(this.stripOffsets[i]);
            this.file.read(data);
            if (this.compression == 1) {
                System.arraycopy(data, 0, imageData, destIndex, data.length);
                destIndex += data.length;
            } else if (this.compression == 32773) {
                destIndex += this.decodePackBits(data, imageData, destIndex);
            } else if (this.compression == 2 || this.compression == 3) {
                int n;
                TIFFModifiedHuffmanCodec codec = new TIFFModifiedHuffmanCodec();
                int nRows = this.rowsPerStrip;
                if (i == length - 1 && (n = this.imageLength % this.rowsPerStrip) != 0) {
                    nRows = n;
                }
                destIndex += codec.decode(data, imageData, destIndex, this.imageWidth, nRows);
            }
            if (this.loader.hasListeners()) {
                this.loader.notifyListeners(new ImageLoaderEvent(this.loader, image, i, i == length - 1));
            }
            ++i;
        }
    }

    PaletteData getColorMap() throws IOException {
        int numColors = 1 << this.bitsPerSample[0];
        int numBytes = 6 * numColors;
        byte[] buffer = new byte[numBytes];
        this.file.seek(this.colorMapOffset);
        this.file.read(buffer);
        RGB[] colors = new RGB[numColors];
        int offset = this.isLittleEndian ? 1 : 0;
        int startG = 2 * numColors;
        int startB = startG + 2 * numColors;
        int i = 0;
        while (i < numColors) {
            int r = buffer[offset] & 0xFF;
            int g = buffer[startG + offset] & 0xFF;
            int b = buffer[startB + offset] & 0xFF;
            colors[i] = new RGB(r, g, b);
            offset += 2;
            ++i;
        }
        return new PaletteData(colors);
    }

    PaletteData getGrayPalette() {
        int numColors = 1 << this.bitsPerSample[0];
        RGB[] rgbs = new RGB[numColors];
        int i = 0;
        while (i < numColors) {
            int value = i * 255 / (numColors - 1);
            if (this.photometricInterpretation == 0) {
                value = 255 - value;
            }
            rgbs[i] = new RGB(value, value, value);
            ++i;
        }
        return new PaletteData(rgbs);
    }

    PaletteData getRGBPalette(int bitsR, int bitsG, int bitsB) {
        int blueMask = 0;
        int i = 0;
        while (i < bitsB) {
            blueMask |= 1 << i;
            ++i;
        }
        int greenMask = 0;
        int i2 = bitsB;
        while (i2 < bitsB + bitsG) {
            greenMask |= 1 << i2;
            ++i2;
        }
        int redMask = 0;
        int i3 = bitsB + bitsG;
        while (i3 < bitsB + bitsG + bitsR) {
            redMask |= 1 << i3;
            ++i3;
        }
        return new PaletteData(redMask, greenMask, blueMask);
    }

    void parseEntries(byte[] buffer) throws IOException {
        int offset = 0;
        while (offset < buffer.length) {
            int tag = this.toInt(buffer, offset, 3);
            int type = this.toInt(buffer, offset + 2, 3);
            int count = this.toInt(buffer, offset + 4, 4);
            switch (tag) {
                case 254: {
                    this.subfileType = this.getEntryValue(type, buffer, offset);
                    break;
                }
                case 255: {
                    int oldSubfileType = this.getEntryValue(type, buffer, offset);
                    this.subfileType = oldSubfileType == 2 ? 1 : (oldSubfileType == 3 ? 2 : 0);
                    break;
                }
                case 256: {
                    this.imageWidth = this.getEntryValue(type, buffer, offset);
                    break;
                }
                case 257: {
                    this.imageLength = this.getEntryValue(type, buffer, offset);
                    break;
                }
                case 258: {
                    if (type != 3) {
                        SWT.error(40);
                    }
                    this.bitsPerSample = new int[count];
                    this.getEntryValue(type, buffer, offset, this.bitsPerSample);
                    break;
                }
                case 259: {
                    this.compression = this.getEntryValue(type, buffer, offset);
                    break;
                }
                case 266: {
                    break;
                }
                case 270: {
                    break;
                }
                case 262: {
                    this.photometricInterpretation = this.getEntryValue(type, buffer, offset);
                    break;
                }
                case 273: {
                    if (type != 4 && type != 3) {
                        SWT.error(40);
                    }
                    this.stripOffsets = new int[count];
                    this.getEntryValue(type, buffer, offset, this.stripOffsets);
                    break;
                }
                case 274: {
                    break;
                }
                case 277: {
                    if (type != 3) {
                        SWT.error(40);
                    }
                    this.samplesPerPixel = this.getEntryValue(type, buffer, offset);
                    if (this.samplesPerPixel == 1 || this.samplesPerPixel == 3) break;
                    SWT.error(38);
                    break;
                }
                case 278: {
                    this.rowsPerStrip = this.getEntryValue(type, buffer, offset);
                    break;
                }
                case 279: {
                    this.stripByteCounts = new int[count];
                    this.getEntryValue(type, buffer, offset, this.stripByteCounts);
                    break;
                }
                case 282: {
                    break;
                }
                case 283: {
                    break;
                }
                case 284: {
                    break;
                }
                case 292: {
                    if (type != 4) {
                        SWT.error(40);
                    }
                    this.t4Options = this.getEntryValue(type, buffer, offset);
                    if ((this.t4Options & 1) != 1) break;
                    SWT.error(42);
                    break;
                }
                case 296: {
                    break;
                }
                case 305: {
                    break;
                }
                case 306: {
                    break;
                }
                case 320: {
                    if (type != 3) {
                        SWT.error(40);
                    }
                    this.colorMapOffset = this.getEntryValue(4, buffer, offset);
                }
            }
            offset += 12;
        }
    }

    public ImageData read(int[] nextIFDOffset) throws IOException {
        this.bitsPerSample = new int[]{1};
        this.colorMapOffset = -1;
        this.compression = 1;
        this.imageLength = -1;
        this.imageWidth = -1;
        this.photometricInterpretation = -1;
        this.rowsPerStrip = Integer.MAX_VALUE;
        this.samplesPerPixel = 1;
        this.stripByteCounts = null;
        this.stripOffsets = null;
        byte[] buffer = new byte[2];
        this.file.read(buffer);
        int numberEntries = this.toInt(buffer, 0, 3);
        buffer = new byte[12 * numberEntries];
        this.file.read(buffer);
        byte[] buffer2 = new byte[4];
        this.file.read(buffer2);
        nextIFDOffset[0] = this.toInt(buffer2, 0, 4);
        this.parseEntries(buffer);
        PaletteData palette = null;
        this.depth = 0;
        switch (this.photometricInterpretation) {
            case 0: 
            case 1: {
                palette = this.getGrayPalette();
                this.depth = this.bitsPerSample[0];
                break;
            }
            case 2: {
                if (this.colorMapOffset != -1) {
                    SWT.error(40);
                }
                palette = this.getRGBPalette(this.bitsPerSample[0], this.bitsPerSample[1], this.bitsPerSample[2]);
                this.depth = this.bitsPerSample[0] + this.bitsPerSample[1] + this.bitsPerSample[2];
                break;
            }
            case 3: {
                if (this.colorMapOffset == -1) {
                    SWT.error(40);
                }
                palette = this.getColorMap();
                this.depth = this.bitsPerSample[0];
                break;
            }
            default: {
                SWT.error(40);
            }
        }
        ImageData image = ImageData.internal_new(this.imageWidth, this.imageLength, this.depth, palette, 1, null, 0, null, null, -1, -1, 6, 0, 0, 0, 0);
        this.decodePixels(image);
        return image;
    }

    int toInt(byte[] buffer, int i, int type) {
        if (type == 4) {
            return this.isLittleEndian ? buffer[i] & 0xFF | (buffer[i + 1] & 0xFF) << 8 | (buffer[i + 2] & 0xFF) << 16 | (buffer[i + 3] & 0xFF) << 24 : buffer[i + 3] & 0xFF | (buffer[i + 2] & 0xFF) << 8 | (buffer[i + 1] & 0xFF) << 16 | (buffer[i] & 0xFF) << 24;
        }
        if (type == 3) {
            return this.isLittleEndian ? buffer[i] & 0xFF | (buffer[i + 1] & 0xFF) << 8 : buffer[i + 1] & 0xFF | (buffer[i] & 0xFF) << 8;
        }
        SWT.error(40);
        return -1;
    }
}

