/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.image.FileFormat;
import org.eclipse.swt.internal.image.LEDataInputStream;

public final class WinBMPFileFormat
extends FileFormat.StaticImageFileFormat {
    static final int BMPFileHeaderSize = 14;
    static final int BMPHeaderFixedSize = 40;
    static final int BI_RGB = 0;
    static final int BI_RLE8 = 1;
    static final int BI_RLE4 = 2;
    static final int BI_BITFIELDS = 3;
    int importantColors;
    Point pelsPerMeter = new Point(0, 0);

    void decompressData(byte[] src, byte[] dest, int stride, int cmp) {
        if (cmp == 1) {
            if (this.decompressRLE8Data(src, src.length, stride, dest, dest.length) <= 0) {
                SWT.error(40);
            }
            return;
        }
        if (cmp == 2) {
            if (this.decompressRLE4Data(src, src.length, stride, dest, dest.length) <= 0) {
                SWT.error(40);
            }
            return;
        }
        SWT.error(40);
    }

    int decompressRLE4Data(byte[] src, int numBytes, int stride, byte[] dest, int destSize) {
        int sp = 0;
        int se = numBytes;
        int dp = 0;
        int de = destSize;
        int x = 0;
        int y = 0;
        block5: while (sp < se) {
            int len = src[sp] & 0xFF;
            ++sp;
            if (len == 0) {
                len = src[sp] & 0xFF;
                ++sp;
                switch (len) {
                    case 0: {
                        x = 0;
                        dp = ++y * stride;
                        if (dp <= de) continue block5;
                        return -1;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        x += src[sp] & 0xFF;
                        y += src[++sp] & 0xFF;
                        ++sp;
                        dp = y * stride + x / 2;
                        if (dp <= de) continue block5;
                        return -1;
                    }
                    default: {
                        if ((len & 1) != 0) {
                            return -1;
                        }
                        x += len;
                        if ((len /= 2) > se - sp) {
                            return -1;
                        }
                        if (len > de - dp) {
                            return -1;
                        }
                        int i = 0;
                        while (i < len) {
                            dest[dp] = src[sp];
                            ++dp;
                            ++sp;
                            ++i;
                        }
                        if ((sp & 1) == 0) continue block5;
                        ++sp;
                        break;
                    }
                }
                continue;
            }
            if ((len & 1) != 0) {
                return -1;
            }
            x += len;
            byte theByte = src[sp];
            ++sp;
            if ((len /= 2) > de - dp) {
                return -1;
            }
            int i = 0;
            while (i < len) {
                dest[dp] = theByte;
                ++dp;
                ++i;
            }
        }
        return 1;
    }

    int decompressRLE8Data(byte[] src, int numBytes, int stride, byte[] dest, int destSize) {
        int sp = 0;
        int se = numBytes;
        int dp = 0;
        int de = destSize;
        int x = 0;
        int y = 0;
        block5: while (sp < se) {
            int len = src[sp] & 0xFF;
            ++sp;
            if (len == 0) {
                len = src[sp] & 0xFF;
                ++sp;
                switch (len) {
                    case 0: {
                        x = 0;
                        dp = ++y * stride;
                        if (dp <= de) continue block5;
                        return -1;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        x += src[sp] & 0xFF;
                        y += src[++sp] & 0xFF;
                        ++sp;
                        dp = y * stride + x;
                        if (dp <= de) continue block5;
                        return -1;
                    }
                    default: {
                        if (len > se - sp) {
                            return -1;
                        }
                        if (len > de - dp) {
                            return -1;
                        }
                        int i = 0;
                        while (i < len) {
                            dest[dp] = src[sp];
                            ++dp;
                            ++sp;
                            ++i;
                        }
                        if ((sp & 1) != 0) {
                            ++sp;
                        }
                        x += len;
                        break;
                    }
                }
                continue;
            }
            byte theByte = src[sp];
            ++sp;
            if (len > de - dp) {
                return -1;
            }
            int i = 0;
            while (i < len) {
                dest[dp] = theByte;
                ++dp;
                ++i;
            }
            x += len;
        }
        return 1;
    }

    @Override
    boolean isFileFormat(LEDataInputStream stream) throws IOException {
        byte[] header = new byte[18];
        stream.read(header);
        stream.unread(header);
        int infoHeaderSize = header[14] & 0xFF | (header[15] & 0xFF) << 8 | (header[16] & 0xFF) << 16 | (header[17] & 0xFF) << 24;
        return header[0] == 66 && header[1] == 77 && infoHeaderSize >= 40;
    }

    byte[] loadData(byte[] infoHeader) {
        int width = infoHeader[4] & 0xFF | (infoHeader[5] & 0xFF) << 8 | (infoHeader[6] & 0xFF) << 16 | (infoHeader[7] & 0xFF) << 24;
        int height = infoHeader[8] & 0xFF | (infoHeader[9] & 0xFF) << 8 | (infoHeader[10] & 0xFF) << 16 | (infoHeader[11] & 0xFF) << 24;
        int bitCount = infoHeader[14] & 0xFF | (infoHeader[15] & 0xFF) << 8;
        int stride = (width * bitCount + 7) / 8;
        stride = (stride + 3) / 4 * 4;
        byte[] data = this.loadData(infoHeader, stride);
        this.flipScanLines(data, stride, height);
        return data;
    }

    byte[] loadData(byte[] infoHeader, int stride) {
        int height = infoHeader[8] & 0xFF | (infoHeader[9] & 0xFF) << 8 | (infoHeader[10] & 0xFF) << 16 | (infoHeader[11] & 0xFF) << 24;
        if (height < 0) {
            height = -height;
        }
        int dataSize = height * stride;
        byte[] data = new byte[dataSize];
        int cmp = infoHeader[16] & 0xFF | (infoHeader[17] & 0xFF) << 8 | (infoHeader[18] & 0xFF) << 16 | (infoHeader[19] & 0xFF) << 24;
        if (cmp == 0 || cmp == 3) {
            try {
                if (this.inputStream.read(data) != dataSize) {
                    SWT.error(40);
                }
            }
            catch (IOException e) {
                SWT.error(39, e);
            }
        } else {
            int compressedSize = infoHeader[20] & 0xFF | (infoHeader[21] & 0xFF) << 8 | (infoHeader[22] & 0xFF) << 16 | (infoHeader[23] & 0xFF) << 24;
            byte[] compressed = new byte[compressedSize];
            try {
                if (this.inputStream.read(compressed) != compressedSize) {
                    SWT.error(40);
                }
            }
            catch (IOException e) {
                SWT.error(39, e);
            }
            this.decompressData(compressed, data, stride, cmp);
        }
        return data;
    }

    int[] loadFileHeader() {
        int[] header = new int[5];
        try {
            header[0] = this.inputStream.readShort();
            header[1] = this.inputStream.readInt();
            header[2] = this.inputStream.readShort();
            header[3] = this.inputStream.readShort();
            header[4] = this.inputStream.readInt();
        }
        catch (IOException e) {
            SWT.error(39, e);
        }
        if (header[0] != 19778) {
            SWT.error(40);
        }
        return header;
    }

    @Override
    ImageData[] loadFromByteStream() {
        int[] fileHeader = this.loadFileHeader();
        byte[] infoHeader = new byte[40];
        try {
            this.inputStream.read(infoHeader);
        }
        catch (Exception e) {
            SWT.error(39, e);
        }
        int width = infoHeader[4] & 0xFF | (infoHeader[5] & 0xFF) << 8 | (infoHeader[6] & 0xFF) << 16 | (infoHeader[7] & 0xFF) << 24;
        int height = infoHeader[8] & 0xFF | (infoHeader[9] & 0xFF) << 8 | (infoHeader[10] & 0xFF) << 16 | (infoHeader[11] & 0xFF) << 24;
        if (height < 0) {
            height = -height;
        }
        int bitCount = infoHeader[14] & 0xFF | (infoHeader[15] & 0xFF) << 8;
        this.compression = infoHeader[16] & 0xFF | (infoHeader[17] & 0xFF) << 8 | (infoHeader[18] & 0xFF) << 16 | (infoHeader[19] & 0xFF) << 24;
        PaletteData palette = this.loadPalette(infoHeader);
        if (this.inputStream.getPosition() < fileHeader[4]) {
            try {
                this.inputStream.skip(fileHeader[4] - this.inputStream.getPosition());
            }
            catch (IOException e) {
                SWT.error(39, e);
            }
        }
        byte[] data = this.loadData(infoHeader);
        this.importantColors = infoHeader[36] & 0xFF | (infoHeader[37] & 0xFF) << 8 | (infoHeader[38] & 0xFF) << 16 | (infoHeader[39] & 0xFF) << 24;
        int xPelsPerMeter = infoHeader[24] & 0xFF | (infoHeader[25] & 0xFF) << 8 | (infoHeader[26] & 0xFF) << 16 | (infoHeader[27] & 0xFF) << 24;
        int yPelsPerMeter = infoHeader[28] & 0xFF | (infoHeader[29] & 0xFF) << 8 | (infoHeader[30] & 0xFF) << 16 | (infoHeader[31] & 0xFF) << 24;
        this.pelsPerMeter = new Point(xPelsPerMeter, yPelsPerMeter);
        int type = this.compression == 1 || this.compression == 2 ? 1 : 0;
        return new ImageData[]{ImageData.internal_new(width, height, bitCount, palette, 4, data, 0, null, null, -1, -1, type, 0, 0, 0, 0)};
    }

    PaletteData loadPalette(byte[] infoHeader) {
        int depth = infoHeader[14] & 0xFF | (infoHeader[15] & 0xFF) << 8;
        if (depth <= 8) {
            int numColors = infoHeader[32] & 0xFF | (infoHeader[33] & 0xFF) << 8 | (infoHeader[34] & 0xFF) << 16 | (infoHeader[35] & 0xFF) << 24;
            if (numColors == 0) {
                numColors = 1 << depth;
            } else if (numColors > 256) {
                numColors = 256;
            }
            byte[] buf = new byte[numColors * 4];
            try {
                if (this.inputStream.read(buf) != buf.length) {
                    SWT.error(40);
                }
            }
            catch (IOException e) {
                SWT.error(39, e);
            }
            return this.paletteFromBytes(buf, numColors);
        }
        if (depth == 16) {
            if (this.compression == 3) {
                try {
                    return new PaletteData(this.inputStream.readInt(), this.inputStream.readInt(), this.inputStream.readInt());
                }
                catch (IOException e) {
                    SWT.error(39, e);
                }
            }
            return new PaletteData(31744, 992, 31);
        }
        if (depth == 24) {
            return new PaletteData(255, 65280, 0xFF0000);
        }
        if (this.compression == 3) {
            try {
                int maskR = Integer.reverseBytes(this.inputStream.readInt());
                int maskG = Integer.reverseBytes(this.inputStream.readInt());
                int maskB = Integer.reverseBytes(this.inputStream.readInt());
                return new PaletteData(maskR, maskG, maskB);
            }
            catch (IOException e) {
                SWT.error(39, e);
            }
        }
        return new PaletteData(65280, 0xFF0000, -16777216);
    }

    PaletteData paletteFromBytes(byte[] bytes, int numColors) {
        int bytesOffset = 0;
        RGB[] colors = new RGB[numColors];
        int i = 0;
        while (i < numColors) {
            colors[i] = new RGB(bytes[bytesOffset + 2] & 0xFF, bytes[bytesOffset + 1] & 0xFF, bytes[bytesOffset] & 0xFF);
            bytesOffset += 4;
            ++i;
        }
        return new PaletteData(colors);
    }

    void flipScanLines(byte[] data, int stride, int height) {
        int i1 = 0;
        int i2 = (height - 1) * stride;
        int i = 0;
        while (i < height / 2) {
            int index = 0;
            while (index < stride) {
                byte b = data[index + i1];
                data[index + i1] = data[index + i2];
                data[index + i2] = b;
                ++index;
            }
            i1 += stride;
            i2 -= stride;
            ++i;
        }
    }
}

