/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.agent.manager;

import com.aspect.snoop.FunctionHook;
import com.aspect.snoop.SnoopSession;
import com.aspect.snoop.agent.AgentLogger;
import com.aspect.snoop.agent.SnoopAgent;
import com.aspect.snoop.agent.manager.ClassChanges;
import com.aspect.snoop.agent.manager.InstrumentationException;
import com.aspect.snoop.agent.manager.InstrumentationManager;
import com.aspect.snoop.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;

public class SessionManager {
    public static void recycleHooks(SnoopSession session) throws InstrumentationException {
        SessionManager.uninstallHooks(session);
        SessionManager.installHooks(session);
    }

    public static void uninstallHooks(SnoopSession snoopSession) throws InstrumentationException {
        if (snoopSession == null) {
            return;
        }
        InstrumentationManager manager = SnoopAgent.getAgentManager();
        for (FunctionHook hook : snoopSession.getFunctionHooks()) {
            Class clazz = hook.getClazz();
            if (ReflectionUtil.isInterfaceOrAbstract(clazz) || hook.isAppliedToSubtypes()) {
                Class[] subtypes;
                for (Class c : subtypes = SessionManager.getAllSubtypes(clazz)) {
                    if (!manager.hasClassBeenModified(c)) continue;
                    manager.deinstrument(c);
                }
            }
            try {
                if (manager.hasClassBeenModified(clazz)) {
                    manager.deinstrument(clazz);
                    continue;
                }
                AgentLogger.debug("Not de-instrumenting " + clazz.getName() + " because it has no history");
            }
            catch (InstrumentationException e) {
                AgentLogger.error("Problem de-instrumenting class", e);
            }
        }
    }

    public static void installHooks(SnoopSession snoopSession) throws InstrumentationException {
        HashMap<Class, ClassChanges> classChanges = new HashMap<Class, ClassChanges>();
        InstrumentationManager manager = SnoopAgent.getAgentManager();
        for (FunctionHook hook : snoopSession.getFunctionHooks()) {
            if (!hook.isEnabled()) continue;
            String methodName = hook.getMethodName();
            Class[] parameterTypes = hook.getParameterTypes();
            Class clazz = hook.getClazz();
            if (ReflectionUtil.isInterfaceOrAbstract(clazz) || hook.isAppliedToSubtypes()) {
                Class[] subtypes;
                for (Class c : subtypes = SessionManager.getAllSubtypes(clazz)) {
                    if (!SessionManager.hasMethod(c, methodName, parameterTypes)) continue;
                    ClassChanges change = (ClassChanges)classChanges.get(c);
                    if (change == null) {
                        change = new ClassChanges(c);
                        classChanges.put(c, change);
                    }
                    change.registerHook(hook, manager);
                }
            }
            if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()) && !SessionManager.hasMethod(clazz, methodName, parameterTypes)) continue;
            ClassChanges change = (ClassChanges)classChanges.get(clazz);
            if (change == null) {
                change = new ClassChanges(clazz);
                classChanges.put(clazz, change);
            }
            change.registerHook(hook, manager);
        }
        for (Class clazz : classChanges.keySet()) {
            ClassChanges change = (ClassChanges)classChanges.get(clazz);
            manager.instrument(clazz, change.getAllMethodChanges());
        }
    }

    private static Class[] getAllSubtypes(Class clazz) {
        ArrayList<Class> subtypes = new ArrayList<Class>();
        for (Class c : SnoopAgent.getAgentManager().getLoadedClasses()) {
            if (!clazz.isAssignableFrom(c) || c.isInterface() || c.equals(clazz)) continue;
            subtypes.add(c);
        }
        return subtypes.toArray(new Class[0]);
    }

    private static boolean hasMethod(Class c, String name, Class[] params) {
        try {
            Method m = c.getDeclaredMethod(name, params);
            return !Modifier.isAbstract(m.getModifiers());
        }
        catch (Exception exception) {
            return false;
        }
    }
}

