/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.ui.tamper;

import com.aspect.org.jdesktop.application.Action;
import com.aspect.org.jdesktop.application.Application;
import com.aspect.org.jdesktop.application.ApplicationActionMap;
import com.aspect.org.jdesktop.application.ResourceMap;
import com.aspect.snoop.JavaSnoop;
import com.aspect.snoop.SnoopSession;
import com.aspect.snoop.agent.AgentLogger;
import com.aspect.snoop.ui.tamper.ObjectTableModel;
import com.aspect.snoop.ui.tamper.ParameterTableCellRenderer;
import com.aspect.snoop.ui.tamper.PrimitiveTableModel;
import com.aspect.snoop.util.IOUtil;
import com.aspect.snoop.util.ReflectionUtil;
import com.aspect.snoop.util.UIUtil;
import com.thoughtworks.xstream.XStream;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;

public class EditObjectView
extends JDialog {
    private Object toEdit;
    private List<Field> primitiveFields;
    private List<Field> objectFields;
    private String currentOutputFile = "";
    private XStream serializer = new XStream();
    boolean replaceObject = false;
    private JButton btnAcceptChanges;
    private JButton btnLoad;
    private JButton btnSave;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel lblClassName;
    private JTable tblNonPrimitives;
    private JTable tblPrimitives;

    public EditObjectView(Frame parent, boolean modal, Object toEdit) {
        super(parent, modal);
        this.initComponents();
        this.toEdit = toEdit;
        this.initialize();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.tblNonPrimitives = new JTable();
        this.lblClassName = new JLabel();
        this.btnAcceptChanges = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.tblPrimitives = new JTable();
        this.jLabel3 = new JLabel();
        this.btnSave = new JButton();
        this.btnLoad = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = ((JavaSnoop)Application.getInstance(JavaSnoop.class)).getContext().getResourceMap(EditObjectView.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jScrollPane2.setName("jScrollPane2");
        this.tblNonPrimitives.setModel(new DefaultTableModel(new Object[][]{{null}, {null}, {null}, {null}}, new String[]{"Title 2"}));
        this.tblNonPrimitives.setName("tblNonPrimitives");
        this.jScrollPane2.setViewportView(this.tblNonPrimitives);
        this.tblNonPrimitives.getColumnModel().getColumn(0).setHeaderValue(resourceMap.getString("tblNonPrimitives.columnModel.title1", new Object[0]));
        this.lblClassName.setText(resourceMap.getString("lblClassName.text", new Object[0]));
        this.lblClassName.setName("lblClassName");
        this.btnAcceptChanges.setText(resourceMap.getString("btnAcceptChanges.text", new Object[0]));
        this.btnAcceptChanges.setName("btnAcceptChanges");
        this.btnAcceptChanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditObjectView.this.btnAcceptChangesActionPerformed(evt);
            }
        });
        this.jScrollPane3.setName("jScrollPane3");
        this.tblPrimitives.setModel(new DefaultTableModel(new Object[][]{{null}, {null}, {null}, {null}}, new String[]{"Title 2"}));
        this.tblPrimitives.setName("tblPrimitives");
        this.jScrollPane3.setViewportView(this.tblPrimitives);
        this.tblPrimitives.getColumnModel().getColumn(0).setHeaderValue(resourceMap.getString("tblNonPrimitives.columnModel.title1", new Object[0]));
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        ApplicationActionMap actionMap = ((JavaSnoop)Application.getInstance(JavaSnoop.class)).getContext().getActionMap(EditObjectView.class, (Object)this);
        this.btnSave.setAction(actionMap.get("serialize"));
        this.btnSave.setText(resourceMap.getString("btnSave.text", new Object[0]));
        this.btnSave.setName("btnSave");
        this.btnLoad.setAction(actionMap.get("deserialize"));
        this.btnLoad.setText(resourceMap.getString("btnLoad.text", new Object[0]));
        this.btnLoad.setName("btnLoad");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -1, 398, Short.MAX_VALUE).addComponent(this.jScrollPane2, -1, 398, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.lblClassName)).addComponent(this.jLabel3).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.btnSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnLoad).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnAcceptChanges)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.lblClassName)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -2, 111, -2).addGap(11, 11, 11).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 111, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnAcceptChanges).addComponent(this.btnSave).addComponent(this.btnLoad)).addContainerGap()));
        this.pack();
    }

    private void btnAcceptChangesActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    @Action
    public void deserialize() {
        JFileChooser fc = null;
        fc = this.currentOutputFile.length() > 0 && new File(this.currentOutputFile).exists() ? new JFileChooser(new File(this.currentOutputFile).getParentFile()) : new JFileChooser();
        fc.setApproveButtonText("Load");
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().endsWith(".ser");
            }

            @Override
            public String getDescription() {
                return "Serialized object file (.ser)";
            }
        });
        int rc = fc.showOpenDialog(this);
        if (rc == 0) {
            File input = fc.getSelectedFile();
            try {
                byte[] xml = IOUtil.getBytesFromFile(input);
                this.toEdit = this.serializer.fromXML(new String(xml));
                this.replaceObject = true;
                this.initialize();
            }
            catch (IOException ioe) {
                UIUtil.showErrorMessage(this, "Error deserializing object: " + ioe.getMessage());
                AgentLogger.error("Error deserializing object: " + ioe.getMessage(), ioe);
            }
        }
    }

    public boolean shouldReplaceObject() {
        return this.replaceObject;
    }

    @Action
    public void serialize() {
        JFileChooser fc = null;
        fc = this.currentOutputFile.length() > 0 && new File(this.currentOutputFile).exists() ? new JFileChooser(new File(this.currentOutputFile).getParentFile()) : new JFileChooser();
        fc.setApproveButtonText("Save");
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().endsWith(".ser");
            }

            @Override
            public String getDescription() {
                return "Serialized object file (.ser)";
            }
        });
        int rc = fc.showOpenDialog(this);
        if (rc == 0) {
            File of = fc.getSelectedFile();
            try {
                String path = of.getAbsolutePath();
                if (!path.endsWith(".ser")) {
                    path = path + ".ser";
                }
                this.currentOutputFile = path;
                FileOutputStream fos = new FileOutputStream(this.currentOutputFile);
                this.serializer.toXML(this.toEdit, (OutputStream)fos);
                fos.close();
            }
            catch (IOException ioe) {
                UIUtil.showErrorMessage(this, "Error serializing object: " + ioe.getMessage());
                AgentLogger.error("Error serializing object: " + ioe.getMessage(), ioe);
            }
        }
    }

    private void initialize() {
        this.lblClassName.setText(this.toEdit.getClass().getName());
        this.primitiveFields = ReflectionUtil.getAllPrimitiveFields(this.toEdit);
        this.objectFields = ReflectionUtil.getAllNonPrimitiveFields(this.toEdit);
        this.tblNonPrimitives.setModel(new ObjectTableModel(this.toEdit, this.objectFields));
        this.tblPrimitives.setModel(new PrimitiveTableModel(this.toEdit, this.primitiveFields));
        ParameterTableCellRenderer renderer = new ParameterTableCellRenderer();
        this.tblNonPrimitives.setDefaultEditor(JButton.class, renderer);
        this.tblNonPrimitives.setDefaultRenderer(JButton.class, renderer);
        this.tblPrimitives.setRowHeight(25);
        this.tblNonPrimitives.setRowHeight(25);
    }

    public Object getObjectReplacement() {
        return this.toEdit;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditObjectView dialog = new EditObjectView((Frame)new JFrame(), true, new SnoopSession());
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

